<?php
use App\Models\MenuItem;
use App\Models\Page;

$items = MenuItem::whereNull('page_id')->get();
echo "Found " . $items->count() . " unlinked items.\n";

foreach ($items as $item) {
    if (empty($item->title))
        continue;

    // Try finding page by Title (Case insensitive)
    $page = Page::where('title', 'LIKE', $item->title)->first();

    if (!$page) {
        // Try slug from URL
        $path = parse_url($item->url, PHP_URL_PATH);
        if ($path) {
            $slug = trim($path, '/');
            if ($slug) {
                $page = Page::where('slug', $slug)->first();
            }
        }
    }

    if ($page) {
        $item->update(['page_id' => $page->id]);
        echo "Linked Menu Item '{$item->title}' to Page ID {$page->id}\n";
    } else {
        echo "Could not find page for '{$item->title}'\n";
    }
}
