<li class="list-group-item menu-item" data-id="<?php echo e($item->id); ?>">
    <div class="d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <i data-feather="move" class="handle me-2 text-muted cursor-move"></i>
            <span class="item-title fw-bold">
                <?php echo e($item->page_id ? ($item->page->title . ' (Page)') : $item->title); ?>

            </span>
            <small class="text-muted ms-2 url-preview">
                (<?php echo e($item->page_id ? url($item->page->slug) : ($item->url ?? 'No URL')); ?>)
            </small>
        </div>
        <div>
            <button class="btn btn-sm btn-link text-primary edit-item-btn" data-id="<?php echo e($item->id); ?>"
                data-title="<?php echo e($item->title); ?>" data-url="<?php echo e($item->page_id ? url($item->page->slug) : $item->url); ?>"
                data-target="<?php echo e($item->target); ?>">Edit</button>
            <button class="btn btn-sm btn-link text-danger delete-item-btn" data-id="<?php echo e($item->id); ?>">Delete</button>
        </div>
    </div>

    
    <div class="item-settings mt-2 p-2 bg-light border rounded d-none" id="settings-<?php echo e($item->id); ?>">
        <div class="row g-2">
            <div class="col-md-6">
                <label class="small">Title</label>
                <input type="text" class="form-control form-control-sm edit-title" value="<?php echo e($item->title); ?>">
                <?php if($item->page_id): ?>
                    <small class="text-muted d-block mt-1">Linked to Page: <strong><?php echo e($item->page->title); ?></strong></small>
                <?php endif; ?>
            </div>
            <div class="col-md-6">
                <label class="small">URL</label>
                <input type="text" class="form-control form-control-sm edit-url"
                    value="<?php echo e($item->page_id ? url($item->page->slug) : $item->url); ?>" <?php echo e($item->page_id ? 'readonly disabled' : ''); ?>>
                <?php if($item->page_id): ?>
                    <small class="text-muted d-block mt-1">Auto-updated from Page Slug</small>
                <?php endif; ?>
            </div>
            <div class="col-md-4">
                <label class="small">Target</label>
                <select class="form-select form-select-sm edit-target">
                    <option value="_self" <?php echo e($item->target == '_self' ? 'selected' : ''); ?>>Same Tab</option>
                    <option value="_blank" <?php echo e($item->target == '_blank' ? 'selected' : ''); ?>>New Tab</option>
                </select>
            </div>
            <div class="col-12 text-end">
                <button class="btn btn-sm btn-success save-item-btn" data-id="<?php echo e($item->id); ?>">Update</button>
            </div>
        </div>
    </div>

    
    <ul class="list-group nested-sortable mt-2 min-h-10">
        <?php if($item->children && $item->children->count()): ?>
            <?php echo $__env->renderEach('admin.menus.item', $item->children, 'item'); ?>
        <?php endif; ?>
    </ul>
</li><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/menus/item.blade.php ENDPATH**/ ?>