

<?php $__env->startSection('title', $page->seo_title ?? 'Home'); ?>
<?php $__env->startSection('meta_description', $page->seo_description ?? 'Tamio Capital Home'); ?>

<?php $__env->startSection('content'); ?>

    <div role="main" class="main">
        <?php $__currentLoopData = $page->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php 
                $content = $section->content ?? []; 
                $identifier = $section->section_identifier;
            ?>

            <?php switch($identifier):
                
                case ('home_slider'): ?>
                    <?php 
                        $slides = $content['slides'] ?? [];
                        // Logic to fix single slide
                        $slideCount = count($slides);
                        $carouselOptions = [
                            'autoplay' => true,
                            'autoplayTimeout' => 7000,
                            'loop' => $slideCount > 1,
                            'nav' => $slideCount > 1,
                            'dots' => $slideCount > 1,
                        ];
                    ?>
                    <?php if(!empty($slides)): ?>
                    <div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs show-dots-sm show-dots-md nav-style-1 nav-inside nav-inside-plus nav-dark nav-lg nav-font-size-lg show-nav-hover bg-color-quaternary custom-slider-container mb-0"
                        data-plugin-options="<?php echo e(json_encode($carouselOptions)); ?>"
                        data-dynamic-height="['991px','991px','991px','750px','750px']" style="height: 991px;">
                        <div class="owl-stage-outer">
                            <div class="owl-stage">
                                <?php $__currentLoopData = $slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="owl-item position-relative overflow-hidden" style="min-height: 750px;">
                                        <div class="background-wrapper position-absolute top-0 start-0 w-100 h-100" style="z-index: 0;">
                                            <?php
                                                $bgType = $slide['bg_type'] ?? 'image';
                                                $videoUrl = $slide['video_url'] ?? '';
                                                if (($slide['video_source'] ?? 'url') === 'file' && !empty($slide['video_file'])) {
                                                    $videoUrl = asset($slide['video_file']);
                                                }
                                            ?>
                                            <?php if($bgType === 'video' && !empty($videoUrl)): ?>
                                                <video autoplay muted loop playsinline class="w-100 h-100" style="object-fit: cover;">
                                                    <source src="<?php echo e($videoUrl); ?>" type="video/mp4">
                                                </video>
                                            <?php elseif($bgType === 'color'): ?>
                                                <div class="w-100 h-100" style="background-color: <?php echo e($slide['bg_color'] ?? '#333'); ?>;"></div>
                                            <?php else: ?>
                                                <div class="w-100 h-100"
                                                    style="background-image: url(<?php echo e(asset($slide['image'] ?? 'img/slides/slide-1.jpg')); ?>); background-size: cover; background-position: center;">
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <?php if($slide['overlay_enabled'] ?? true): ?>
                                            <div class="position-absolute top-0 start-0 w-100 h-100"
                                                style="background-color: <?php echo e($slide['overlay_color'] ?? '#000000'); ?>; opacity: <?php echo e($slide['overlay_opacity'] ?? '0.5'); ?>; z-index: 1;">
                                            </div>
                                        <?php endif; ?>
                                        <div class="container position-relative z-index-3 h-100">
                                            <div class="row h-100 align-items-center <?php echo e(($slide['align'] ?? 'text-center') == 'text-center' ? 'justify-content-center' : (($slide['align'] ?? '') == 'text-end' ? 'justify-content-end' : '')); ?>">
                                                <div class="col-lg-8 <?php echo e($slide['align'] ?? 'text-center'); ?>">
                                                    <?php
                                                        // Styles
                                                        $tStyle = [];
                                                        if(!empty($slide['title_font_family'])) $tStyle[] = "font-family: '{$slide['title_font_family']}' !important";
                                                        if(!empty($slide['title_font_size'])) $tStyle[] = "font-size: {$slide['title_font_size']}px !important";
                                                        if(!empty($slide['title_color'])) $tStyle[] = "color: {$slide['title_color']} !important";
                                                        if(!empty($slide['title_shadow_color'])) {
                                                            $x = $slide['title_shadow_x'] ?? 0; $y = $slide['title_shadow_y'] ?? 0; $b = $slide['title_shadow_blur'] ?? 0; $c = $slide['title_shadow_color'];
                                                            $tStyle[] = "text-shadow: {$x}px {$y}px {$b}px {$c} !important";
                                                        }
                                                        $tStyleStr = implode(';', $tStyle);
                                                        
                                                        $sStyle = [];
                                                        if(!empty($slide['subtitle_font_family'])) $sStyle[] = "font-family: '{$slide['subtitle_font_family']}' !important";
                                                        if(!empty($slide['subtitle_font_size'])) $sStyle[] = "font-size: {$slide['subtitle_font_size']}px !important";
                                                        if(!empty($slide['subtitle_color'])) $sStyle[] = "color: {$slide['subtitle_color']} !important";
                                                        if(!empty($slide['subtitle_shadow_color'])) {
                                                            $x = $slide['subtitle_shadow_x'] ?? 0; $y = $slide['subtitle_shadow_y'] ?? 0; $b = $slide['subtitle_shadow_blur'] ?? 0; $c = $slide['subtitle_shadow_color'];
                                                            $sStyle[] = "text-shadow: {$x}px {$y}px {$b}px {$c} !important";
                                                        }
                                                        $sStyleStr = implode(';', $sStyle);
                                                    ?>
                                                    <?php if(($slide['title_visible'] ?? '1') && !empty($slide['title'])): ?>
                                                        <h2 class="text-color-primary font-weight-bold text-uppercase text-4 line-height-3 mb-2 appear-animation" style="<?php echo e($tStyleStr); ?>" data-appear-animation="<?php echo e($slide['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e($slide['animation_delay'] ?? '500'); ?>"><span class="line-pre-title bg-color-primary d-none d-lg-inline-block"></span><?php echo e($slide['title']); ?></h2>
                                                    <?php endif; ?>
                                                    <?php if(($slide['subtitle_visible'] ?? '1') && !empty($slide['subtitle'])): ?>
                                                        <h1 class="text-color-secondary font-weight-extra-bold text-10 line-height-2 mb-3 appear-animation" style="<?php echo e($sStyleStr); ?>" data-appear-animation="<?php echo e($slide['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($slide['animation_delay'] ?? '500') + 250); ?>"><?php echo e($slide['subtitle']); ?></h1>
                                                    <?php endif; ?>
                                                    <?php if(($slide['text_visible'] ?? '1') && !empty($slide['text'])): ?>
                                                        <p class="text-4 text-color-light font-weight-light mb-4 appear-animation" data-appear-animation="<?php echo e($slide['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($slide['animation_delay'] ?? '500') + 500); ?>"><?php echo e($slide['text']); ?></p>
                                                    <?php endif; ?>
                                                    <?php if(($slide['button_visible'] ?? '1') && !empty($slide['button_text'])): ?>
                                                        <a href="<?php echo e($slide['button_link'] ?? '#'); ?>" class="btn <?php echo e($slide['btn_style'] ?? 'btn-primary'); ?> btn-modern font-weight-bold text-2 btn-py-3 px-5 mt-2 appear-animation" data-appear-animation="<?php echo e($slide['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($slide['animation_delay'] ?? '500') + 750); ?>"><?php echo e($slide['button_text']); ?></a>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="owl-nav"><button type="button" role="presentation" class="owl-prev" aria-label="Previous"></button><button type="button" role="presentation" class="owl-next" aria-label="Next"></button></div>
                    </div>
                    <?php endif; ?>
                    <?php break; ?>

                
                <?php case ('home_features_overlap'): ?>
                    <?php $features = $content['features'] ?? []; ?>
                    <?php if(!empty($features)): ?>
                        <div class="container" style="margin-top: -150px; position: relative; z-index: 5;">
                            <div class="row">
                                <?php $__currentLoopData = $features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-4 mb-4 mb-lg-0 appear-animation" data-appear-animation="<?php echo e($feature['animation_type'] ?? 'fadeInRightShorter'); ?>" data-appear-animation-delay="<?php echo e($feature['animation_delay'] ?? (200 + ($index * 200))); ?>">
                                        <div class="card bg-white border-0 box-shadow-1">
                                            <div class="card-body p-5 text-center">
                                                
                                                <div style="display: inline-block;">
                                                    <i class="<?php echo e($feature['icon_class']); ?> text-color-primary text-10 mb-3 d-block"></i>
                                                </div>
                                                <h4 class="font-weight-bold text-5 mb-3 text-color-dark"><?php echo e($feature['title']); ?></h4>
                                                <p class="mb-4"><?php echo e($feature['description']); ?></p>
                                                <a href="<?php echo e($feature['link'] ?? '#'); ?>" class="text-uppercase font-weight-bold text-2 text-decoration-none text-color-primary">Read More +</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php break; ?>

                
                <?php case ('home_banner_simple'): ?>
                    <?php
                        $minHeight = $content['min_height'] ?? '400';
                        $textAlign = $content['text_align'] ?? 'text-center';
                        $paddingY = $content['padding_y'] ?? '5';
                    ?>
                    <section class="section border-0 m-0 py-<?php echo e($paddingY); ?> d-flex align-items-center" 
                             style="background-image: url(<?php echo e(asset($content['image'] ?? '')); ?>); background-size: cover; background-position: center; position: relative; min-height: <?php echo e($minHeight); ?>px;">
                         <div class="position-absolute top-0 start-0 w-100 h-100" style="background-color: #000; opacity: <?php echo e($content['overlay_opacity'] ?? '0.5'); ?>;"></div>
                         <div class="container position-relative z-index-1">
                            <div class="row align-items-center <?php echo e($textAlign); ?>">
                                <div class="col <?php echo e(!empty($content['animation_type']) ? 'appear-animation' : ''); ?>" data-appear-animation="<?php echo e($content['animation_type'] ?? ''); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>">
                                    <h2 class="text-color-light font-weight-bold text-9 mb-2"><?php echo e($content['title'] ?? ''); ?></h2>
                                    <p class="text-color-light text-5 font-weight-light"><?php echo e($content['subtitle'] ?? ''); ?></p>
                                    <?php if(!empty($content['btn_text'])): ?>
                                        <a href="<?php echo e($content['btn_link'] ?? '#'); ?>" class="btn btn-primary btn-modern font-weight-bold text-3 px-5 py-3"><?php echo e($content['btn_text']); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                         </div>
                    </section>
                    <?php break; ?>

                
                <?php case ('home_video_block'): ?>
                     <?php
                        $containerWidth = $content['container_width'] ?? 'container';
                        $paddingY = $content['padding_y'] ?? '5';
                        $boxShadow = !empty($content['box_shadow']) ? 'box-shadow-4' : '';
                        $borderRadius = $content['border_radius'] ?? '0';
                        $vUrl = $content['video_url'] ?? ''; 
                        $cover = $content['cover_image'] ?? '';
                     ?>
                     <section class="section border-0 m-0 py-<?php echo e($paddingY); ?>" style="background-color: transparent;">
                        <div class="<?php echo e($containerWidth); ?> <?php echo e(!empty($content['animation_type']) ? 'appear-animation' : ''); ?>" data-appear-animation="<?php echo e($content['animation_type'] ?? ''); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>">
                            <div class="overflow-hidden <?php echo e($boxShadow); ?>" style="border-radius: <?php echo e($borderRadius); ?>px;">
                                <?php if(($content['source_type'] ?? '') == 'file'): ?>
                                    <video controls class="w-100 d-block" poster="<?php echo e(asset($cover)); ?>">
                                        <source src="<?php echo e(asset($vUrl)); ?>" type="video/mp4">
                                    </video>
                                <?php else: ?>
                                    <div class="ratio ratio-16x9">
                                        <iframe src="<?php echo e($vUrl); ?>" allowfullscreen></iframe>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                     </section>
                    <?php break; ?>

                
                <?php case ('home_multi_column'): ?>
                    <?php 
                        $layout = $content['layout'] ?? '2';
                        $colClass = $layout == '2' ? 'col-md-6' : ($layout == '3' ? 'col-md-4' : 'col-md-3');
                        $cols = $content['columns'] ?? [];
                        $gap = $content['gap'] ?? '4'; // mapped to g-* or mb-* logic
                        $alignItems = $content['align_items'] ?? 'align-items-start';
                        $rowGapClass = 'g-' . $gap;
                    ?>
                    <div class="container-fluid py-5" style="background-color: <?php echo e($content['bg_color'] ?? '#ffffff'); ?>;">
                        <div class="container">
                            <div class="row <?php echo e($rowGapClass); ?> <?php echo e($alignItems); ?>">
                                <?php for($i=1; $i<=$layout; $i++): ?>
                                    <div class="<?php echo e($colClass); ?> mb-4 mb-md-0 <?php echo e(!empty($content['animation_type']) ? 'appear-animation' : ''); ?>" data-appear-animation="<?php echo e($content['animation_type'] ?? ''); ?>" data-appear-animation-delay="<?php echo e(($content['animation_delay'] ?? '200') + ($i * 200)); ?>">
                                        <?php echo $cols[$i]['html'] ?? ''; ?>

                                    </div>
                                <?php endfor; ?>
                            </div>
                        </div>
                    </div>
                    <?php break; ?>

                
                <?php case ('home_services_with_image'): ?>
                     <?php $servicesList = \App\Models\Service::where('is_active', true)->orderBy('sort_order', 'asc')->latest()->take(5)->get(); ?>
                     <?php if($servicesList->isNotEmpty()): ?>
                        <div class="container-fluid" style="background-color: <?php echo e($content['bg_color'] ?? '#ffffff'); ?>; color: <?php echo e($content['text_color'] ?? '#333333'); ?>;">
                            <div class="container py-5 my-5">
                                <div class="row align-items-center">
                                    <div class="col-lg-6 mb-5 mb-lg-0">
                                        <?php if(!empty($content['image'])): ?> <img src="<?php echo e(asset($content['image'])); ?>" class="img-fluid rounded box-shadow-3 appear-animation" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>"> <?php endif; ?>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="overflow-hidden mb-2"><h2 class="text-color-primary font-weight-bold text-uppercase text-4 mb-0 appear-animation" data-appear-animation="<?php echo e($content['animation_type'] ?? 'maskUp'); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>"><?php echo e($content['subtitle'] ?? 'OUR SERVICES'); ?></h2></div>
                                        <h2 class="font-weight-bold text-9 mb-4 appear-animation" style="color: <?php echo e($content['text_color'] ?? '#212529'); ?>;" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($content['animation_delay'] ?? '200') + 200); ?>"><?php echo e($content['title'] ?? 'What We Do?'); ?></h2>
                                        <p class="text-4 mb-5 appear-animation" style="color: <?php echo e($content['text_color'] ?? '#777'); ?>;" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($content['animation_delay'] ?? '200') + 400); ?>"><?php echo e($content['description'] ?? ''); ?></p>
                                        <div class="accordion accordion-modern" id="accordionServices<?php echo e($loop->index); ?>">
                                            <?php $__currentLoopData = $servicesList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $svc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="card card-default">
                                                    <div class="card-header"><h4 class="card-title m-0"><a class="accordion-toggle font-weight-bold <?php echo e($idx === 0 ? '' : 'collapsed'); ?>" style="color: <?php echo e($content['text_color'] ?? '#212529'); ?>;" data-bs-toggle="collapse" data-bs-parent="#accordionServices<?php echo e($loop->parent->index); ?>" href="#collapseService<?php echo e($loop->parent->index); ?>_<?php echo e($idx); ?>"><?php echo e($svc->title); ?></a></h4></div>
                                                    <div id="collapseService<?php echo e($loop->parent->index); ?>_<?php echo e($idx); ?>" class="collapse <?php echo e($idx === 0 ? 'show' : ''); ?>"><div class="card-body"><p><?php echo e($svc->short_description); ?></p><a href="<?php echo e(route('services.show', $svc->slug)); ?>" class="text-uppercase text-1 font-weight-bold text-color-primary">Read More +</a></div></div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php if(!empty($content['button_text'])): ?> 
                                            <a href="<?php echo e($content['button_link'] ?? '#'); ?>" class="btn <?php echo e($content['btn_style'] ?? 'btn-primary'); ?> btn-modern font-weight-bold text-3 btn-px-5 py-3 mt-4 appear-animation" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($content['animation_delay'] ?? '200') + 600); ?>"><?php echo e($content['button_text']); ?></a> 
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                     <?php endif; ?>
                    <?php break; ?>

                
                <?php case ('home_portfolio_tabs'): ?>
                    <?php $tabs = $content['tabs'] ?? []; ?>
                    <div class="container py-4">
                        <div class="row"><div class="col"><div class="tabs tabs-bottom tabs-center tabs-simple">
                            <ul class="nav nav-tabs">
                                <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <li class="nav-item"><a class="nav-link <?php echo e($idx === 0 ? 'active' : ''); ?>" href="#tabsNav<?php echo e($loop->parent->index); ?>_<?php echo e($idx); ?>" data-bs-toggle="tab"><?php echo e($tab['title']); ?></a></li> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="tab-content">
                                <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="tab-pane <?php echo e($idx === 0 ? 'active' : ''); ?>" id="tabsNav<?php echo e($loop->parent->index); ?>_<?php echo e($idx); ?>">
                                        <div class="text-center"><h4 class="text-color-primary font-weight-bold"><?php echo e($tab['title']); ?></h4><div class="row align-items-center"><div class="col-lg-6"><p class="text-4"><?php echo $tab['content']; ?></p></div><div class="col-lg-6"><?php if(!empty($tab['image'])): ?> <img src="<?php echo e(asset($tab['image'])); ?>" class="img-fluid rounded"> <?php endif; ?></div></div></div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div></div></div>
                    </div>
                    <?php break; ?>

                
                <?php case ('home_logos_grid'): ?>
                    <?php $logos = $content['logos'] ?? []; ?>
                    <?php if(!empty($logos)): ?>
                        <div class="container-fluid" style="background-color: <?php echo e($content['bg_color'] ?? '#ffffff'); ?>; color: <?php echo e($content['text_color'] ?? '#333333'); ?>;">
                            <div class="container"><div class="row text-center pt-4 mt-5"><div class="col"><h2 class="font-weight-bold text-8 mb-2 appear-animation" style="color: <?php echo e($content['text_color'] ?? '#333333'); ?>;" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>"><?php echo e($content['title'] ?? "We're proud to work with"); ?></h2></div></div><div class="row text-center mt-5 pb-5 mb-5"><div class="owl-carousel owl-theme carousel-center-active-item mb-0" data-plugin-options="{'responsive': {'0': {'items': 1}, '476': {'items': 1}, '768': {'items': 5}, '992': {'items': 7}, '1200': {'items': 7}}, 'autoplay': true, 'autoplayTimeout': 3000, 'dots': false}">
                                <?php $__currentLoopData = $logos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <div><img class="img-fluid" src="<?php echo e(asset($logo)); ?>" alt="Partner Logo"></div> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div></div></div>
                        </div>
                    <?php endif; ?>
                    <?php break; ?>

                
                <?php case ('home_news'): ?>
                    <?php $latestNews = \App\Models\NewsPost::where('status', 'published')->latest()->take(2)->get(); ?>
                    <?php if($latestNews->isNotEmpty()): ?>
                        <section class="our-blog" style="background-color: <?php echo e($content['bg_color'] ?? '#ffffff'); ?>; pb-5">
                            <div class="container">
                                <div class="row mt-3 pt-5"><div class="col"><p class="text-uppercase font-weight-semibold mb-1 text-color-primary appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100"><span class="line-pre-title bg-color-primary"></span><?php echo e($content['subtitle'] ?? 'Our Blog'); ?></p><h2 class="font-weight-bold text-capitalize mb-4 custom-letter-spacing-2 custom-text-1 appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200" style="color: <?php echo e($content['text_color'] ?? '#212529'); ?>;"><?php echo e($content['title'] ?? 'News and Articles'); ?></h2></div></div>
                                <div class="row mb-3 pb-5"><div class="col"><div class="row">
                                    <?php $__currentLoopData = $latestNews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-6 mb-4 mb-lg-0"><article><div class="card border-0 border-radius-0 box-shadow-1 appear-animation" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInUpShorter'); ?>" data-appear-animation-delay="<?php echo e(($content['animation_delay'] ?? '500') + ($loop->index * 200)); ?>"><div class="card-body p-4 z-index-1"><a href="<?php echo e(route('news.show', $post->slug)); ?>"><img class="card-img-top border-radius-0" src="<?php echo e(asset($post->featured_image ?? 'img/demos/business-consulting-2/blog/blog-1.png')); ?>" style="height: 240px; object-fit: cover;"></a><p class="text-uppercase text-1 mb-3 pt-1 text-color-default"><time pubdate datetime="<?php echo e($post->published_at->format('Y-m-d')); ?>"><?php echo e($post->published_at->format('d M Y')); ?></time><span class="opacity-3 d-inline-block px-2">|</span>0 Comments<span class="opacity-3 d-inline-block px-2">|</span>Tamio</p><div class="card-body p-0"><h4 class="card-title mb-3 text-5 font-weight-bold"><a class="text-color-secondary" href="<?php echo e(route('news.show', $post->slug)); ?>"><?php echo e($post->title); ?></a></h4><p class="card-text mb-3"><?php echo e(Str::limit(strip_tags($post->content), 120)); ?></p><a href="<?php echo e(route('news.show', $post->slug)); ?>" class="font-weight-bold text-uppercase text-decoration-none d-block mt-3">Read More +</a></div></div></div></article></div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div></div></div>
                            </div>
                        </section>
                    <?php endif; ?>
                    <?php break; ?>

                
                <?php case ('home_newsletter'): ?>
                    <section class="section section-no-border m-0" style="background-color: <?php echo e($content['bg_color'] ?? '#F4F4F4'); ?>; color: <?php echo e($content['text_color'] ?? '#333333'); ?>;">
                        <div class="container py-5">
                            <div class="row align-items-center">
                                <div class="col-lg-6 mb-5 mb-lg-0 text-start appear-animation" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInRightShorter'); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>">
                                    <h2 class="font-weight-bold text-9 mb-3" style="color: <?php echo e($content['title_color'] ?? '#333333'); ?>;"><?php echo e($content['title'] ?? 'Get the Latest from Tamio Capital'); ?></h2>
                                    <p class="text-4 mb-0" style="color: <?php echo e($content['text_color'] ?? '#777777'); ?>;"><?php echo e($content['description'] ?? 'Subscribe to our newsletter to stay up to date on our partners, portfolio, and more.'); ?></p>
                                </div>
                                <div class="col-lg-6 appear-animation" data-appear-animation="<?php echo e($content['animation_type'] ?? 'fadeInLeftShorter'); ?>" data-appear-animation-delay="<?php echo e($content['animation_delay'] ?? '200'); ?>">
                                    <div class="card bg-white border-0 border-radius-0 box-shadow-1">
                                        <div class="card-body p-5">
                                            <h4 class="card-title mb-4 font-weight-bold text-dark">Subscribe</h4>
                                            <form id="newsletterForm" action="<?php echo e(route('newsletter.subscribe')); ?>" method="POST">
                                                <?php echo csrf_field(); ?> 
                                                <div class="form-group mb-3 text-start">
                                                    <label class="form-label text-dark font-weight-bold">Name <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="name" required placeholder="Please enter your full name">
                                                </div>
                                                <div class="form-group mb-3 text-start">
                                                    <label class="form-label text-dark font-weight-bold">Company <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="company" required placeholder="Please enter your company's name">
                                                </div>
                                                <div class="form-group mb-4 text-start">
                                                    <label class="form-label text-dark font-weight-bold">Email <span class="text-danger">*</span></label>
                                                    <input type="email" class="form-control" name="email" required placeholder="Please enter a valid email address">
                                                </div>
                                                <div class="d-grid"><button class="btn btn-primary btn-modern font-weight-bold text-3 py-3" type="submit">SUBMIT</button></div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    <?php break; ?>

            <?php endswitch; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/home.blade.php ENDPATH**/ ?>