

<?php $__env->startSection('title', $page->seo_title ?? 'Contact'); ?>
<?php $__env->startSection('meta_description', $page->seo_description ?? 'Contact Us'); ?>

<?php $__env->startSection('content'); ?>

    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">Contact Us</h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="active">Contact Us</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <section class="custom-bg-color-lighter-grey">
            <?php
                $contactSection = $page->sections->firstWhere('section_identifier', 'contact_info');
                $content = $contactSection ? ($contactSection->content ?? []) : [];
            ?>
            <div class="cards custom-cards h-auto pt-5 pb-4 container appear-animation"
                data-appear-animation="fadeInUpShorter" data-appear-animation-delay="100">
                <div
                    class="row bg-color-light cards-container d-flex justify-content-center justify-content-xl-between w-100 mb-5 mx-0 box-shadow-1 p-relative top-0">
                    <div class="col-sm-12 col-md-6 col-xl-4 bg-light p-0 shadow-none">
                        <div class="card border-radius-0 border-0 shadow-none">
                            <div class="card-body d-flex align-items-center justify-content-between flex-column z-index-1">
                                <h4 class="card-title mb-4 font-weight-semibold text-color-primary">Get In Touch</h4>
                                <strong class="d-block text-secondary text-4">Work Inquiries</strong>
                                <p class="d-block m-0"><?php echo e($content['phone'] ?? '(800) 123-4567'); ?></p>
                                <strong class="d-block text-secondary text-4 pt-4">Assistance Hours:</strong>
                                
                                <p class="d-block m-0"><?php echo e($content['phone_hours'] ?? 'Mon - Sat 9:00am - 6:00pm'); ?></p>
                                <p class="d-block m-0">Sunday - CLOSED</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-xl-4 bg-light p-0 shadow-none">
                        <div class="card border-radius-0 border-0 shadow-none">
                            <div class="card-body d-flex align-items-center justify-content-between flex-column z-index-1">
                                <h4 class="card-title mb-4 font-weight-semibold text-color-primary">Address and Mail</h4>
                                <strong class="d-block text-secondary text-4">Address</strong>
                                <p class="d-block m-0">
                                    <?php echo e($content['address'] ?? '123 Street Name, City, Country'); ?>

                                </p>
                                <strong class="d-block text-secondary text-4 pt-4">E-mail</strong>
                                <p class="d-block m-0">
                                    <a class="text-default"
                                        href="mailto:<?php echo e($content['email'] ?? 'business@tamio-capital.com'); ?>"><?php echo e($content['email'] ?? 'business@tamio-capital.com'); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-md-6 col-xl-4 bg-light p-0 shadow-none">
                        <div class="card border-radius-0 border-0 shadow-none">
                            <div
                                class="card-body d-flex align-items-center justify-content-between flex-column z-index-1 border-end-0">
                                <h4 class="card-title mb-4 font-weight-semibold text-color-primary">Social Media</h4>
                                <ul class="social-icons custom-social-icons p-0 pt-3 m-0">
                                    <?php if(!empty($content['linkedin_url'])): ?>
                                        <li class="m-0 d-block pb-2 social-icons-linkedin">
                                            <a class="custom-bg-color-light-grey" href="<?php echo e($content['linkedin_url']); ?>"
                                                target="_blank" title="LinkedIn">
                                                <i
                                                    class="fab fa-linkedin-in text-4 font-weight-semibold text-color-secondary"></i>
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="container py-5">
            <div class="row">
                <div class="col">
                    <p class="text-uppercase font-weight-semibold mb-1 text-color-primary appear-animation"
                        data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100"><span
                            class="line-pre-title bg-color-primary"></span>Get in Touch</p>
                    <h2 class="text-color-secondary font-weight-bold text-capitalize mb-2 custom-letter-spacing-2 custom-text-1 appear-animation"
                        data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">Send Us a Message</h2>
                    <p class="mb-4 appear-animation" data-appear-animation="fadeInRightShorter"
                        data-appear-animation-delay="300">We would love to hear from you. Please fill out the form below and
                        we will get back to you as soon as possible.</p>
                    <?php if(session('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form class="contact-form custom-form-style-1 appear-animation" data-appear-animation="fadeIn"
                        data-appear-animation-delay="100" action="<?php echo e(route('contact.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="form-group col-lg-6">
                                <input type="text" placeholder="Your Name" value="<?php echo e(old('name')); ?>"
                                    data-msg-required="Please enter your name." maxlength="100" class="form-control"
                                    name="name" required>
                            </div>
                            <div class="form-group col-lg-6">
                                <input type="email" placeholder="Your E-mail" value="<?php echo e(old('email')); ?>"
                                    data-msg-required="Please enter your email address."
                                    data-msg-email="Please enter a valid email address." maxlength="100"
                                    class="form-control" name="email" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col">
                                <input placeholder="Subject" type="text" value="<?php echo e(old('subject')); ?>"
                                    data-msg-required="Please enter the subject." maxlength="100" class="form-control"
                                    name="subject" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col">
                                <textarea placeholder="Your Message..." maxlength="5000"
                                    data-msg-required="Please enter your message." rows="10" class="form-control"
                                    name="message" required><?php echo e(old('message')); ?></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col">
                                <input type="submit" value="Send Message"
                                    class="btn btn-primary custom-btn text-center text-uppercase text-decoration-none border-0 py-0 px-5 font-weight-semibold"
                                    data-loading-text="Loading...">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/contact.blade.php ENDPATH**/ ?>