

<?php $__env->startSection('title', isset($company) ? 'Edit Company' : 'Create Company'); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3"><?php echo e(isset($company) ? 'Edit Company' : 'Create Company'); ?></h1>

    <form action="<?php echo e(isset($company) ? route('admin.portfolio.update', $company->id) : route('admin.portfolio.store')); ?>"
        method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php if(isset($company)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Company Info</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Company Name</label>
                            <input type="text" class="form-control" name="name" value="<?php echo e($company->name ?? ''); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description"
                                rows="4"><?php echo e($company->description ?? ''); ?></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Services (One per line)</label>
                            <textarea class="form-control" name="services"
                                rows="4"><?php echo e($company->services ?? ''); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Classification</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="portfolio_category_id" required>
                                <option value="">Select Category</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($cat->id); ?>" <?php echo e((isset($company) && $company->portfolio_category_id == $cat->id) ? 'selected' : ''); ?>>
                                        <?php echo e($cat->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sector Label</label>
                            <input type="text" class="form-control" name="sector" value="<?php echo e($company->sector ?? ''); ?>"
                                placeholder="e.g. Technology">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" class="form-control" name="sort_order"
                                value="<?php echo e($company->sort_order ?? 0); ?>">
                        </div>
                    </div>
                </div>

                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Media</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Logo</label>
                            <div class="input-group mb-2">
                                <input type="text" name="logo" id="logo" class="form-control"
                                    value="<?php echo e($company->logo ?? ''); ?>" placeholder="Select path or upload new" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#logo"
                                    data-preview-target="#logo_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="logo_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="logo_preview" class="mt-2 text-center bg-light p-2 rounded">
                                <?php if(isset($company->logo)): ?>
                                    <img src="<?php echo e(asset($company->logo)); ?>" class="img-fluid" style="max-height: 50px">
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <div class="input-group mb-2">
                                <input type="text" name="featured_image" id="featured_image" class="form-control"
                                    value="<?php echo e($company->featured_image ?? ''); ?>" placeholder="Select path or upload new"
                                    readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#featured_image"
                                    data-preview-target="#featured_image_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="featured_image_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="featured_image_preview" class="mt-2">
                                <?php if(isset($company->featured_image)): ?>
                                    <img src="<?php echo e(asset($company->featured_image)); ?>" class="mt-2 img-fluid"
                                        style="max-height: 100px;">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Company</button>
                </div>
            </div>
        </div>
    </form>
    <?php echo $__env->make('admin.media.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/portfolio/create.blade.php ENDPATH**/ ?>