

<?php $__env->startSection('title', 'News Post'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">News Posts</h1>
        <a href="<?php echo e(route('admin.news.create')); ?>" class="btn btn-primary">Add New Post</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Status</th>
                    <th>Published At</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($post->title); ?></td>
                        <td>
                            <span class="badge <?php echo e($post->status == 'published' ? 'bg-success' : 'bg-secondary'); ?>">
                                <?php echo e(ucfirst($post->status)); ?>

                            </span>
                        </td>
                        <td><?php echo e(\Carbon\Carbon::parse($post->published_at)->format('M d, Y')); ?></td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.news.edit', $post->id)); ?>" class="btn btn-sm btn-primary">Edit</a>
                            <form action="<?php echo e(route('admin.news.destroy', $post->id)); ?>" method="POST" class="d-inline-block">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"
                                    onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/news/index.blade.php ENDPATH**/ ?>