<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $__env->yieldContent('title', 'Admin'); ?> | Tamio Capital</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/feather-icons"></script>
    
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
    
    
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            // Initialize Summernote
            // We use jQuery here because Summernote is valid plugin
            $('.rich-text-editor').summernote({
                placeholder: 'Content goes here...',
                tabsize: 2,
                height: 600,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });

            feather.replace();
        });

        // Global Toast Notification Helper
        function showToast(message, type = 'success') {
            var toastContainer = document.getElementById('toast-container');
            var bgClass = type === 'success' ? 'text-bg-success' : 'text-bg-danger';

            var toastHtml = `
                <div class="toast align-items-center ${bgClass} border-0" role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body">
                            ${message}
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                </div>
            `;

            var toastElement = document.createElement('div');
            toastElement.innerHTML = toastHtml;
            toastContainer.appendChild(toastElement.firstElementChild);

            var toast = new bootstrap.Toast(toastContainer.lastElementChild);
            toast.show();
        }

        // Fullscreen Toggle
        function toggleFullScreen() {
            if (!document.fullscreenElement) {
                document.documentElement.requestFullscreen();
            } else {
                if (document.exitFullscreen) {
                    document.exitFullscreen();
                }
            }
        }

        // Sidebar Toggle
        document.addEventListener("DOMContentLoaded", function () {
            const sidebarToggle = document.querySelector('.js-sidebar-toggle');
            const sidebar = document.querySelector('.sidebar');

            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function () {
                    sidebar.classList.toggle('collapsed');
                });
            }
        });
    </script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: #f5f7fb;
        }

        .wrapper {
            display: flex;
            width: 100%;
            align-items: stretch;
        }

        .sidebar {
            min-width: 260px;
            max-width: 260px;
            background: #222e3c;
            color: #fff;
            transition: margin-left .35s ease-in-out;
            min-height: 100vh;
        }

        .sidebar.collapsed {
            margin-left: -260px;
        }

        .sidebar-brand {
            font-weight: 600;
            font-size: 1.15rem;
            padding: 1.15rem 1.5rem;
            display: block;
            color: #f8f9fa;
            text-decoration: none;
        }

        .sidebar-nav {
            padding: 0;
            list-style: none;
        }

        .sidebar-header {
            background: transparent;
            padding: 1.5rem 1.5rem .375rem;
            font-size: .75rem;
            color: #ced4da;
        }

        .sidebar-item {
            border-left: 3px solid transparent;
        }

        .sidebar-item.active {
            border-left-color: #3b7ddd;
            background: rgba(59, 125, 221, 0.1);
        }

        .sidebar-item.active .sidebar-link {
            color: #f8f9fa;
        }

        .sidebar-item.active .sidebar-link svg {
            color: #f8f9fa;
        }

        .sidebar-link {
            padding: .625rem 1.625rem;
            color: rgba(233, 236, 239, .5);
            display: block;
            text-decoration: none;
            position: relative;
            transition: color .075s ease-in-out;
            border-left: 3px solid transparent;
        }

        .sidebar-link:hover {
            color: rgba(233, 236, 239, .75);
        }

        .sidebar-link svg {
            margin-right: .75rem;
            color: rgba(233, 236, 239, .5);
            width: 18px;
            height: 18px;
        }

        .hamburger {
            position: relative;
        }

        .hamburger,
        .hamburger:after,
        .hamburger:before {
            display: inline-block;
            vertical-align: middle;
            width: 24px;
            height: 2px;
            background-color: #495057;
            border-radius: 1px;
            transition: background-color .1s ease-in-out, color .1s ease-in-out;
        }

        .hamburger:after,
        .hamburger:before {
            content: "";
            position: absolute;
            left: 0;
        }

        .hamburger:before {
            top: -6px;
        }

        .hamburger:after {
            top: 6px;
        }

        .sidebar-toggle {
            cursor: pointer;
            width: 26px;
            height: 26px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1rem;
        }

        .main {
            width: 100%;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        .navbar {
            background: #fff;
            padding: .875rem 1.5rem;
            box-shadow: 0 0 2rem 0 rgba(33, 40, 50, .1);
        }

        .content {
            flex: 1;
            padding: 1.5rem;
        }

        .card {
            box-shadow: 0 0 .875rem 0 rgba(33, 40, 50, .05);
            border: 0;
            margin-bottom: 24px;
        }

        .footer {
            background: #fff;
            padding: 1rem;
            color: #6c757d;
            font-size: .8rem;
        }

        .btn-primary {
            background: #3b7ddd;
            border-color: #3b7ddd;
        }
    </style>
</head>

<body>
    
    <div class="toast-container position-fixed bottom-0 end-0 p-3" id="toast-container" style="z-index: 1050;"></div>

    <div class="wrapper">
        <nav class="sidebar">
            <a class="sidebar-brand" href="<?php echo e(route('admin.dashboard')); ?>">
                Tamio Admin
            </a>
            <ul class="sidebar-nav">
                <li class="sidebar-header">Core</li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.dashboard')); ?>">
                        <i data-feather="sliders"></i> <span class="align-middle">Dashboard</span>
                    </a>
                </li>

                <li class="sidebar-header">Content</li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.pages.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.pages.index')); ?>">
                        <i data-feather="layout"></i> <span class="align-middle">Pages</span>
                    </a>
                </li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.menus.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.menus.index')); ?>">
                        <i data-feather="menu"></i> <span class="align-middle">Menus</span>
                    </a>
                </li>
                <li
                    class="sidebar-item <?php echo e(request()->routeIs('admin.portfolio.*') || request()->routeIs('admin.portfolio-categories.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.portfolio.index')); ?>">
                        <i data-feather="briefcase"></i> <span class="align-middle">Portfolio</span>
                    </a>
                </li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.team.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.team.index')); ?>">
                        <i data-feather="users"></i> <span class="align-middle">Team</span>
                    </a>
                </li>
                <li
                    class="sidebar-item <?php echo e(request()->routeIs('admin.careers.*') || request()->routeIs('admin.careers.applications.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.careers.jobs.index')); ?>">
                        <i data-feather="monitor"></i> <span class="align-middle">Careers</span>
                    </a>
                </li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.news.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.news.index')); ?>">
                        <i data-feather="file-text"></i> <span class="align-middle">News</span>
                    </a>
                </li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.services.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.services.index')); ?>">
                        <i data-feather="check-square"></i> <span class="align-middle">Services</span>
                    </a>
                </li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.newsletter.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.newsletter.index')); ?>">
                        <i data-feather="mail"></i> <span class="align-middle">Newsletter</span>
                    </a>
                </li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.media.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.media.index')); ?>">
                        <i data-feather="image"></i> <span class="align-middle">Media Library</span>
                    </a>
                </li>

                <li class="sidebar-header">System</li>
                <li class="sidebar-item <?php echo e(request()->routeIs('admin.settings.*') ? 'active' : ''); ?>">
                    <a class="sidebar-link" href="<?php echo e(route('admin.settings.edit')); ?>">
                        <i data-feather="settings"></i> <span class="align-middle">Settings</span>
                    </a>
                </li>
            </ul>
        </nav>

        <div class="main">
            <nav class="navbar navbar-expand navbar-light navbar-bg border-bottom">
                <a class="sidebar-toggle js-sidebar-toggle">
                    <i class="hamburger align-self-center"></i>
                </a>
                <div class="navbar-collapse collapse">
                    <ul class="navbar-nav ms-auto align-items-center">
                        <li class="nav-item"><a class="nav-link" href="<?php echo e(route('home')); ?>" target="_blank"
                                title="View Website"><i data-feather="globe"></i></a></li>
                        <li class="nav-item"><a class="nav-link" href="#" onclick="toggleFullScreen(); return false;"
                                title="Fullscreen"><i data-feather="maximize"></i></a></li>
                        <li class="nav-item"><a class="nav-link" href="#" title="Notifications"><span
                                    class="position-relative"><i data-feather="bell"></i><span
                                        class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle"></span></span></a>
                        </li>
                        </li>

                        <li class="nav-item dropdown ms-3">
                            <a class="nav-link dropdown-toggle position-relative" href="#" id="userDropdown"
                                role="button" data-bs-toggle="dropdown">
                                <div class="d-inline-flex align-items-center">
                                    <div class="bg-danger text-white rounded d-flex align-items-center justify-content-center me-2 font-weight-bold"
                                        style="width: 36px; height: 36px;">SA</div>
                                    <div class="text-start">
                                        <span class="text-dark d-block fw-bold">Super Admin</span>
                                    </div>
                                </div>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end pt-0 pb-0 shadow-lg border-0">
                                <a class="dropdown-item py-2 border-bottom" href="#"><i data-feather="user"
                                        class="align-middle me-2"></i> Profile</a>
                                <a class="dropdown-item py-2 border-bottom" href="#"><i data-feather="lock"
                                        class="align-middle me-2"></i> Lock Screen</a>
                                <a class="dropdown-item py-2 border-bottom" href="<?php echo e(route('admin.settings.edit')); ?>"><i
                                        data-feather="settings" class="align-middle me-2"></i> Settings</a>
                                <form action="<?php echo e(route('logout')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <button class="dropdown-item py-2 text-danger" type="submit">Log out</button>
                                </form>
                            </div>
                        </li>
                    </ul>
                </div>
            </nav>

            <main class="content">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
            </main>

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row text-muted">
                        <div class="col-6 text-start">
                            <p class="mb-0">
                                <strong>Tamio Capital</strong> &copy; <?php echo e(date('Y')); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        feather.replace();
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\laragon\www\tamio-capital\resources\views/layouts/admin.blade.php ENDPATH**/ ?>