

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-8">
            <h1 class="h3 text-gray-800">Services</h1>
        </div>
        <div class="col-4 text-end">
            <a href="<?php echo e(route('admin.services.create')); ?>" class="btn btn-primary">
                <i class="align-middle" data-feather="plus"></i> New Service
            </a>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Created</th>
                            <th>Title</th>
                            <th>Slug</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($service->created_at->format('Y-m-d')); ?></td>
                                <td><?php echo e($service->title); ?></td>
                                <td><?php echo e($service->slug); ?></td>
                                <td>
                                    <?php if($service->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary">Draft</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.services.edit', $service)); ?>" class="btn btn-sm btn-primary">
                                        <i class="align-middle" data-feather="edit"></i>
                                    </a>
                                    <form action="<?php echo e(route('admin.services.destroy', $service)); ?>" method="POST"
                                        class="d-inline" onsubmit="return confirm('Are you sure?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-danger">
                                            <i class="align-middle" data-feather="trash-2"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">No services found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e($services->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/services/index.blade.php ENDPATH**/ ?>