

<?php $__env->startSection('title', 'Portfolio Companies'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Portfolio Companies</h1>
        <div>
            <a href="<?php echo e(route('admin.portfolio-categories.index')); ?>" class="btn btn-outline-secondary me-2">Manage
                Categories</a>
            <a href="<?php echo e(route('admin.portfolio.create')); ?>" class="btn btn-primary">Add New Company</a>
        </div>
    </div>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover my-0">
                <thead>
                    <tr>
                        <th>Logo</th>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Sector</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php if($company->logo): ?>
                                    <img src="<?php echo e($company->logo); ?>" style="width: 40px; height: 40px; object-fit: contain;">
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($company->name); ?></td>
                            <td><?php echo e($company->category_name); ?></td>
                            <td><?php echo e($company->sector); ?></td>
                            <td class="text-end">
                                <a href="<?php echo e(route('admin.portfolio.edit', $company->id)); ?>"
                                    class="btn btn-sm btn-primary">Edit</a>
                                <form action="<?php echo e(route('admin.portfolio.destroy', $company->id)); ?>" method="POST"
                                    class="d-inline-block">
                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger"
                                        onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/portfolio/index.blade.php ENDPATH**/ ?>