

<?php $__env->startSection('content'); ?>
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 text-gray-800">Edit Service</h1>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="<?php echo e(route('admin.services.update', $service)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" name="title" class="form-control" value="<?php echo e(old('title', $service->title)); ?>"
                                required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Short Description (for Homepage/Lists)</label>
                            <textarea name="short_description" class="form-control" rows="3" maxlength="500"
                                required><?php echo e(old('short_description', $service->short_description)); ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Full Content</label>
                            <textarea name="content"
                                class="form-control rich-text-editor"><?php echo e(old('content', $service->content)); ?></textarea>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="is_active" class="form-select">
                                <option value="1" <?php echo e(old('is_active', $service->is_active) ? 'selected' : ''); ?>>Active
                                </option>
                                <option value="0" <?php echo e(!old('is_active', $service->is_active) ? 'selected' : ''); ?>>Draft
                                </option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" name="sort_order" class="form-control"
                                value="<?php echo e(old('sort_order', $service->sort_order)); ?>">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="image" id="image_input"
                                    value="<?php echo e(old('image', $service->image)); ?>" readonly>
                                <button class="btn btn-outline-secondary" type="button" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-id="image_input">
                                    Select
                                </button>
                            </div>
                            <div class="mt-2">
                                <img id="image_input_preview" src="<?php echo e($service->image ? asset($service->image) : ''); ?>"
                                    style="max-width: 100%; <?php echo e($service->image ? '' : 'display:none;'); ?>"
                                    class="img-thumbnail">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-end">
                    <a href="<?php echo e(route('admin.services.index')); ?>" class="btn btn-secondary me-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">Update Service</button>
                </div>
            </form>
        </div>
    </div>

    <?php echo $__env->make('admin.media.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function () {
            $('.rich-text-editor').summernote({
                height: 400
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/services/edit.blade.php ENDPATH**/ ?>