

<?php $__env->startSection('title', $page->seo_title ?? 'Approach'); ?>
<?php $__env->startSection('meta_description', $page->seo_description ?? 'Our Approach'); ?>

<?php $__env->startSection('content'); ?>

    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            <?php echo e($page->title); ?>

                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="active"><?php echo e($page->title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <?php
            $introSection = $page->sections->firstWhere('section_identifier', 'about_intro');
            $content = $introSection ? ($introSection->content ?? []) : [];
        ?>

        <?php if($introSection): ?>
            <div class="container py-5">
                <div class="row align-items-center">
                    <div class="col">
                        <?php if(!empty($content['subheading'])): ?>
                            <p class="text-4 line-height-9"><?php echo e($content['subheading']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6">
                        <?php if(!empty($content['body'])): ?>
                            <?php echo $content['body']; ?>

                        <?php endif; ?>

                        <?php if(!empty($content['stat_percent'])): ?>
                            <div class="d-flex align-items-center justify-content-start pt-4 appear-animation"
                                data-appear-animation="fadeIn" data-appear-animation-delay="600">
                                <div class="circular-bar custom-circular-bar m-0">
                                    <div class="circular-bar-chart" data-percent="<?php echo e($content['stat_percent']); ?>"
                                        data-plugin-options="{'barColor': '#e8465f'}">
                                        <strong class="text-5 text-color-tertiary"><?php echo e($content['stat_percent']); ?>%</strong>
                                    </div>
                                </div>
                                <h4 class="font-weight-bold text-color-tertiary m-0 ms-3"><?php echo $content['stat_text'] ?? ''; ?></h4>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-lg-6 pt-4 pt-lg-0">
                        <?php if(!empty($content['image'])): ?>
                            <div class="card border-radius-0 box-shadow-1 border-0 mt-4 mt-lg-0 ms-lg-3 p-3 mb-3 mb-lg-0">
                                <img src="<?php echo e(asset($content['image'])); ?>" class="img-fluid border-radius-0" alt="Approach">
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            
            <div class="container py-5">
                <div class="alert alert-warning">
                    Content section "about_intro" not found. Please create it in the Admin Panel.
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/approach.blade.php ENDPATH**/ ?>