

<?php $__env->startSection('title', 'Pages'); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3">Pages</h1>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover my-0">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Slug</th>
                        <th>Template</th>
                        <th>Last Updated</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($page->title); ?></td>
                            <td><span class="badge bg-secondary"><?php echo e($page->slug); ?></span></td>
                            <td><?php echo e(ucfirst($page->template)); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($page->updated_at)->diffForHumans()); ?></td>
                            <td class="text-end">
                                <a href="<?php echo e(route('admin.pages.sections.index', $page->id)); ?>"
                                    class="btn btn-sm btn-info me-1">Sections</a>
                                <a href="<?php echo e(route('admin.pages.edit', $page->id)); ?>" class="btn btn-sm btn-primary">Edit</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/pages/index.blade.php ENDPATH**/ ?>