

<?php $__env->startSection('title', isset($member) ? 'Edit Member' : 'Add Member'); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3"><?php echo e(isset($member) ? 'Edit Member' : 'Add Member'); ?></h1>

    <form action="<?php echo e(isset($member) ? route('admin.team.update', $member->id) : route('admin.team.store')); ?>" method="POST"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php if(isset($member)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Full Name</label>
                            <input type="text" class="form-control" name="name" value="<?php echo e($member->name ?? ''); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Job Title</label>
                            <input type="text" class="form-control" name="title" value="<?php echo e($member->title ?? ''); ?>"
                                required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Bio</label>
                            <textarea class="form-control" name="bio" rows="4"><?php echo e($member->bio ?? ''); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Member Type</label>
                            <select class="form-select" name="type">
                                <option value="team" <?php echo e((isset($member) && $member->type == 'team') ? 'selected' : ''); ?>>Team
                                </option>
                                <option value="executive" <?php echo e((isset($member) && $member->type == 'executive') ? 'selected' : ''); ?>>Executive Board</option>
                                <option value="board" <?php echo e((isset($member) && $member->type == 'board') ? 'selected' : ''); ?>>
                                    Board Member</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">LinkedIn URL</label>
                            <input type="url" class="form-control" name="linkedin_url"
                                value="<?php echo e($member->linkedin_url ?? ''); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" class="form-control" name="sort_order"
                                value="<?php echo e($member->sort_order ?? 0); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Photo</label>
                            <div class="input-group mb-2">
                                <input type="text" name="photo" id="photo" class="form-control"
                                    value="<?php echo e($member->photo ?? ''); ?>" placeholder="Select path or upload new" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#photo"
                                    data-preview-target="#photo_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="photo_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="photo_preview" class="mt-2">
                                <?php if(isset($member->photo)): ?>
                                    <img src="<?php echo e(asset($member->photo)); ?>" class="mt-2" style="max-height: 100px;">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Member</button>
                </div>
            </div>
        </div>
    </form>
    <?php echo $__env->make('admin.media.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/team/create.blade.php ENDPATH**/ ?>