

<?php $__env->startSection('title', 'Team Members'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Team Members</h1>
        <a href="<?php echo e(route('admin.team.create')); ?>" class="btn btn-primary">Add Member</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php if($member->photo): ?>
                                <img src="<?php echo e($member->photo); ?>" class="rounded-circle"
                                    style="width: 40px; height: 40px; object-fit: cover;">
                            <?php else: ?>
                                <div class="bg-secondary rounded-circle" style="width: 40px; height: 40px;"></div>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($member->name); ?></td>
                        <td><?php echo e($member->title); ?></td>
                        <td>
                            <span
                                class="badge <?php echo e($member->type == 'executive' ? 'bg-primary' : ($member->type == 'board' ? 'bg-info' : 'bg-secondary')); ?>">
                                <?php echo e(ucfirst($member->type)); ?>

                            </span>
                        </td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.team.edit', $member->id)); ?>" class="btn btn-sm btn-primary">Edit</a>
                            <form action="<?php echo e(route('admin.team.destroy', $member->id)); ?>" method="POST" class="d-inline-block">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"
                                    onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/team/index.blade.php ENDPATH**/ ?>