

<?php $__env->startSection('content'); ?>
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">Careers</h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="active">Careers</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <div class="container py-5">
            <div class="row">
                <div class="col">
                    <?php
                        $introSection = $page ? $page->sections->firstWhere('section_identifier', 'careers_intro') : null;
                        $content = $introSection ? ($introSection->content ?? []) : [];
                    ?>
                    <h2 class="font-weight-bold text-color-secondary"><?php echo e($content['title'] ?? 'Join Our Team'); ?></h2>
                    <p class="text-4">
                        <?php echo e($content['text'] ?? 'We are always looking for talented individuals to join our growing team. Check out our open positions below.'); ?>

                    </p>

                    <hr class="my-5">

                    <?php if(Session::has('success')): ?>
                        <div class="alert alert-success">
                            <?php echo e(Session::get('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <?php if($jobs->count() > 0): ?>
                        <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="card mb-4 box-shadow-1 border-0">
                                <div class="card-body">
                                    <h3 class="font-weight-bold text-color-dark"><?php echo e($job->title); ?></h3>
                                    <p class="text-uppercase text-2 text-color-primary"><?php echo e($job->type); ?> - <?php echo e($job->location); ?></p>
                                    <div class="mb-3">
                                        <?php echo Str::limit($job->description, 200); ?>

                                    </div>
                                    <button type="button" class="btn btn-primary font-weight-bold text-uppercase"
                                        data-bs-toggle="modal" data-bs-target="#applyModal" data-bs-job-id="<?php echo e($job->id); ?>"
                                        data-bs-job-title="<?php echo e($job->title); ?>">
                                        Apply Now
                                    </button>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- Application Modal -->
                        <div class="modal fade" id="applyModal" tabindex="-1" aria-labelledby="applyModalLabel"
                            aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <form action="<?php echo e(route('careers.apply')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="career_job_id" id="career_job_id">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="applyModalLabel">Apply for <span
                                                    id="jobTitlePlaceholder"></span></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3">
                                                <label for="full_name" class="form-label">Full Name</label>
                                                <input type="text" class="form-control" id="full_name" name="full_name"
                                                    required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="email" class="form-label">Email Address</label>
                                                <input type="email" class="form-control" id="email" name="email" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="phone" class="form-label">Phone</label>
                                                <input type="text" class="form-control" id="phone" name="phone">
                                            </div>
                                            <div class="mb-3">
                                                <label for="cv" class="form-label">Resume/CV (PDF/DOC)</label>
                                                <input type="file" class="form-control" id="cv" name="cv" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="cover_letter" class="form-label">Cover Letter</label>
                                                <textarea class="form-control" id="cover_letter" name="cover_letter"
                                                    rows="3"></textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Submit Application</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <?php $__env->startPush('scripts'); ?>
                            <script>
                                var applyModal = document.getElementById('applyModal')
                                applyModal.addEventListener('show.bs.modal', function (event) {
                                    var button = event.relatedTarget
                                    var jobId = button.getAttribute('data-bs-job-id')
                                    var jobTitle = button.getAttribute('data-bs-job-title')
                                    var modalTitle = applyModal.querySelector('#jobTitlePlaceholder')
                                    var modalInputId = applyModal.querySelector('#career_job_id')

                                    modalTitle.textContent = jobTitle
                                    modalInputId.value = jobId
                                })
                            </script>
                        <?php $__env->stopPush(); ?>

                    <?php else: ?>
                        <div class="alert alert-info">
                            There are currently no open positions. However, we are always interested in meeting talented people.
                            Feel free to send your resume to our contact email.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/careers.blade.php ENDPATH**/ ?>