

<?php $__env->startSection('content'); ?>
    <div class="container-fluid p-0">

        <div class="d-flex justify-content-between align-items-center mb-3">
            <h1 class="h3 mb-0">Media Library</h1>
            <button class="btn btn-primary" data-bs-toggle="collapse" data-bs-target="#uploadArea">
                <i data-feather="upload-cloud"></i> Upload New
            </button>
        </div>

        
        <div class="collapse mb-4" id="uploadArea">
            <div class="card">
                <div class="card-body">
                    <form action="<?php echo e(route('admin.media.store')); ?>" method="POST" enctype="multipart/form-data"
                        class="row align-items-end">
                        <?php echo csrf_field(); ?>
                        <div class="col-md-4">
                            <label class="form-label">Select File</label>
                            <input type="file" name="file" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Destination Folder</label>
                            <select name="folder" class="form-select">
                                <option value="uploads">Default (uploads)</option>
                                <option value="uploads/settings">Settings</option>
                                <option value="uploads/sections">Sections</option>
                                <option value="uploads/portfolio">Portfolio</option>
                                <option value="uploads/team">Team</option>
                                <option value="uploads/news">News</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <button type="submit" class="btn btn-success w-100">Upload File</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        
        <div class="card mb-3">
            <div class="card-body p-2">
                <div class="input-group">
                    <span class="input-group-text"><i data-feather="search"></i></span>
                    <input type="text" id="media-search" class="form-control" placeholder="Search files by name...">
                </div>
            </div>
        </div>

        
        <div class="row" id="media-grid">
            <?php $__empty_1 = true; $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-6 col-md-3 col-xl-2 mb-4 media-item" data-name="<?php echo e(strtolower($file['name'])); ?>">
                    <div class="card h-100 shadow-sm">
                        <div class="card-img-top d-flex align-items-center justify-content-center bg-light"
                            style="height: 150px; overflow: hidden;">
                            <?php if($file['is_image']): ?>
                                <img src="<?php echo e($file['url']); ?>" alt="<?php echo e($file['name']); ?>" class="img-fluid"
                                    style="max-height: 100%; max-width: 100%; object-fit: contain;">
                            <?php else: ?>
                                <i data-feather="file" class="text-secondary" style="width: 48px; height: 48px;"></i>
                            <?php endif; ?>
                        </div>
                        <div class="card-body p-2 d-flex flex-column">
                            <small class="text-truncate fw-bold mb-1" title="<?php echo e($file['name']); ?>"><?php echo e($file['name']); ?></small>
                            <div class="d-flex justify-content-between align-items-center mt-auto">
                                <small class="text-muted" style="font-size: 0.75rem;"><?php echo e($file['size']); ?></small>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-sm btn-light copy-url" data-url="<?php echo e($file['url']); ?>"
                                        title="Copy URL">
                                        <i data-feather="copy" class="width-12 height-12"></i>
                                    </button>
                                    <form action="<?php echo e(route('admin.media.destroy')); ?>" method="POST"
                                        onsubmit="return confirm('Delete this file?');" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <input type="hidden" name="path" value="<?php echo e($file['path']); ?>">
                                        <button type="submit" class="btn btn-sm btn-light text-danger" title="Delete">
                                            <i data-feather="trash-2" class="width-12 height-12"></i>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12 text-center py-5">
                    <i data-feather="image" class="text-muted mb-2" style="width: 48px; height: 48px;"></i>
                    <p class="text-muted">No media files found.</p>
                </div>
            <?php endif; ?>
        </div>

    </div>

    <?php $__env->startPush('scripts'); ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                // Search Filter
                const searchInput = document.getElementById('media-search');
                const items = document.querySelectorAll('.media-item');

                searchInput.addEventListener('input', function (e) {
                    const term = e.target.value.toLowerCase();
                    items.forEach(item => {
                        const name = item.getAttribute('data-name');
                        if (name.includes(term)) {
                            item.classList.remove('d-none');
                        } else {
                            item.classList.add('d-none');
                        }
                    });
                });

                // Copy URL
                const copyBtns = document.querySelectorAll('.copy-url');
                copyBtns.forEach(btn => {
                    btn.addEventListener('click', function () {
                        const url = this.getAttribute('data-url');
                        navigator.clipboard.writeText(url).then(() => {
                            const originalHtml = this.innerHTML;
                            this.innerHTML = '<i data-feather="check" class="width-12 height-12 text-success"></i>';
                            feather.replace();
                            setTimeout(() => {
                                this.innerHTML = originalHtml;
                                feather.replace();
                            }, 1500);
                        });
                    });
                });
            });
        </script>
        <style>
            .width-12 {
                width: 12px;
            }

            .height-12 {
                height: 12px;
            }
        </style>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/media/index.blade.php ENDPATH**/ ?>