

<?php $__env->startSection('title', isset($post) ? 'Edit News' : 'Create News'); ?>

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3"><?php echo e(isset($post) ? 'Edit News' : 'Create News'); ?></h1>

    <form action="<?php echo e(isset($post) ? route('admin.news.update', $post->id) : route('admin.news.store')); ?>" method="POST"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php if(isset($post)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" class="form-control" name="title" value="<?php echo e($post->title ?? ''); ?>" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Content</label>
                            <textarea class="form-control" name="content" rows="10"
                                id="editor"><?php echo e($post->content ?? ''); ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Publishing</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status">
                                <option value="draft" <?php echo e((isset($post) && $post->status == 'draft') ? 'selected' : ''); ?>>Draft
                                </option>
                                <option value="published" <?php echo e((isset($post) && $post->status == 'published') ? 'selected' : ''); ?>>Published</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Date</label>
                            <input type="datetime-local" class="form-control" name="published_at"
                                value="<?php echo e(isset($post->published_at) ? \Carbon\Carbon::parse($post->published_at)->format('Y-m-d\TH:i') : now()->format('Y-m-d\TH:i')); ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <div class="input-group mb-2">
                                <input type="text" name="featured_image" id="featured_image" class="form-control"
                                    value="<?php echo e($post->featured_image ?? ''); ?>" placeholder="Select path or upload new"
                                    readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#featured_image"
                                    data-preview-target="#featured_image_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="featured_image_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="featured_image_preview" class="mt-2">
                                <?php if(isset($post->featured_image)): ?>
                                    <img src="<?php echo e(asset($post->featured_image)); ?>" class="mt-2 img-fluid">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Post</button>
                </div>
            </div>
        </div>
    </form>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
        <script>
            ClassicEditor.create(document.querySelector('#editor')).catch(error => { console.error(error); });
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.media.modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/news/create.blade.php ENDPATH**/ ?>