

<?php $__env->startSection('title', 'Job Openings'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Job Openings</h1>
        <a href="<?php echo e(route('admin.careers.jobs.create')); ?>" class="btn btn-primary">Add New Job</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Department</th>
                    <th>Location</th>
                    <th>Status</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($job->title); ?></td>
                        <td><?php echo e($job->department); ?></td>
                        <td><?php echo e($job->location); ?></td>
                        <td>
                            <span class="badge <?php echo e($job->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e($job->is_active ? 'Active' : 'Closed'); ?>

                            </span>
                        </td>
                        <td class="text-end">
                            <a href="<?php echo e(route('admin.careers.jobs.edit', $job->id)); ?>" class="btn btn-sm btn-primary">Edit</a>
                            <form action="<?php echo e(route('admin.careers.jobs.destroy', $job->id)); ?>" method="POST"
                                class="d-inline-block">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger"
                                    onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/careers/jobs/index.blade.php ENDPATH**/ ?>