<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Basic -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $__env->yieldContent('title', 'Tamio Capital'); ?></title>
    <meta name="keywords" content="<?php echo $__env->yieldContent('meta_keywords', 'Tamio Capital, Private Equity, Investment'); ?>" />
    <meta name="description"
        content="<?php echo $__env->yieldContent('meta_description', 'Tamio Capital - Reliable Management Consulting Services'); ?>">
    <meta name="author" content="Tamio Capital">

    <!-- Favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset($globalSettings['site_favicon'] ?? 'img/favicon.ico')); ?>"
        type="image/x-icon" />
    <link rel="apple-touch-icon" href="<?php echo e(asset('img/apple-touch-icon.png')); ?>">

    <!-- Mobile Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

    <!-- Web Fonts  -->
    <!-- Web Fonts  -->
    <?php
        $fontFamily = $globalSettings['font_family'] ?? 'Poppins';
        $isSystemFont = in_array($fontFamily, ['Times New Roman', 'Arial', 'Helvetica', 'Verdana']);
        if (!$isSystemFont) {
            $fontUrl = 'https://fonts.googleapis.com/css?family=' . urlencode($fontFamily) . ':300,400,500,600,700&display=swap';
        }
    ?>
    <?php if(!$isSystemFont): ?>
        <link id="googleFonts" href="<?php echo e($fontUrl); ?>" rel="stylesheet" type="text/css">
    <?php endif; ?>



    <!-- Vendor CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('vendor/bootstrap/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/fontawesome-free/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/animate/animate.compat.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/simple-line-icons/css/simple-line-icons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/owl.carousel/assets/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/owl.carousel/assets/owl.theme.default.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/magnific-popup/magnific-popup.min.css')); ?>">

    <!-- Theme CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/theme.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/theme-elements.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/theme-blog.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/theme-shop.css')); ?>">

    <!-- Demo CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/demos/demo-business-consulting-2.css')); ?>">

    <!-- Skin CSS -->
    <link id="skinCSS" rel="stylesheet" href="<?php echo e(asset('css/skins/skin-business-consulting-2.css')); ?>">

    <!-- Theme Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">

    <?php echo $__env->yieldPushContent('styles'); ?>

    <style>
        html {
            scroll-behavior: smooth;
        }

        :root {
            --primary:
                <?php echo e($globalSettings['primary_color'] ?? '#0088cc'); ?>

            ;
            --secondary:
                <?php echo e($globalSettings['secondary_color'] ?? '#e36159'); ?>

            ;
            --tertiary:
                <?php echo e($globalSettings['tertiary_color'] ?? '#2baab1'); ?>

            ;
            --quaternary:
                <?php echo e($globalSettings['quaternary_color'] ?? '#383f48'); ?>

            ;
            --font-family: "<?php echo e($fontFamily); ?>",
                <?php echo e(in_array($fontFamily, ['Times New Roman', 'Playfair Display']) ? 'serif' : 'sans-serif'); ?>

            ;
        }

        body,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        .h1,
        .h2,
        .h3,
        .h4,
        .h5,
        .h6,
        p,
        a,
        div,
        span,
        li,
        input,
        textarea,
        button {
            font-family: var(--font-family) !important;
        }

        .text-color-primary {
            color: var(--primary) !important;
        }

        .bg-color-primary {
            background-color: var(--primary) !important;
        }

        .btn-primary {
            background-color: var(--primary) !important;
            border-color: var(--primary) !important;
        }

        .text-color-secondary {
            color: var(--secondary) !important;
        }

        .bg-color-secondary {
            background-color: var(--secondary) !important;
        }
    </style>
</head>

<body>
    <div class="body">
        <header id="header" class="header-effect-shrink"
            data-plugin-options="{'stickyEnabled': true, 'stickyEffect': 'shrink', 'stickyEnableOnBoxed': true, 'stickyEnableOnMobile': false, 'stickyChangeLogo': true, 'stickyStartAt': 120, 'stickyHeaderContainerHeight': 70}">
            <div class="header-body border-top-0">
                <div class="header-top header-top-default header-top-borders border-bottom-0 bg-color-light">
                    <div class="container h-100">
                        <div class="header-row h-100">
                            <div class="header-column justify-content-between">
                                <div class="header-row">
                                    <nav class="header-nav-top w-100">
                                        <ul class="nav nav-pills justify-content-between w-100 h-100">
                                            <li class="nav-item py-2 d-inline-flex">
                                                <?php
                                                    $headerStyle = "font-size: " . ($globalSettings['header_font_size'] ?? '12') . "px; " .
                                                        "font-weight: " . ($globalSettings['header_font_weight'] ?? '600') . "; " .
                                                        "color: " . ($globalSettings['header_text_color'] ?? '#E36159') . ";";
                                                ?>
                                                <span
                                                    class="header-top-phone py-2 d-flex align-items-center text-uppercase"
                                                    style="<?php echo e($headerStyle); ?>">
                                                    <span>
                                                        <img width="15" height="18"
                                                            src="<?php echo e(asset('img/demos/business-consulting-2/icons/phone.svg')); ?>"
                                                            alt="Phone">
                                                    </span>
                                                    <a class="text-decoration-none ms-2" style="<?php echo e($headerStyle); ?>"
                                                        href="tel:<?php echo e($globalSettings['contact_phone'] ?? '123-456-7890'); ?>"><?php echo e($globalSettings['contact_phone'] ?? '(800) 123-4567'); ?></a>
                                                </span>
                                                <span
                                                    class="header-top-email px-0 font-weight-normal align-items-center d-none d-xl-flex ms-3"
                                                    style="<?php echo e($headerStyle); ?>">
                                                    <span>
                                                        <img width="25" height="18"
                                                            src="<?php echo e(asset('img/demos/business-consulting-2/icons/mail.svg')); ?>"
                                                            alt="Mail">
                                                    </span>
                                                    <a class="text-decoration-none ms-2" style="<?php echo e($headerStyle); ?>"
                                                        href="mailto:<?php echo e($globalSettings['contact_email'] ?? 'business@tamio-capital.com'); ?>"><?php echo e($globalSettings['contact_email'] ?? 'business@tamio-capital.com'); ?></a>
                                                </span>
                                                <?php if(isset($globalSettings['contact_hours'])): ?>
                                                    <div class="header-top-opening-hours px-0 font-weight-normal align-items-center d-none d-xl-flex ms-3"
                                                        style="<?php echo e($headerStyle); ?>">
                                                        <span>
                                                            <img width="19" height="19"
                                                                src="<?php echo e(asset('img/demos/business-consulting-2/icons/calendar.svg')); ?>"
                                                                alt="Calendar">
                                                        </span>
                                                        <div class="ps-2" style="white-space: nowrap;">
                                                            <?php echo e($globalSettings['contact_hours']); ?>

                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </li>
                                            <li
                                                class="nav-item nav-item-header-top-socials d-none d-md-flex justify-content-between h-100">
                                                <span
                                                    class="header-top-button-make-as-appoitment d-inline-flex align-items-center justify-content-center h-100 p-0 align-top">
                                                    <a href="<?php echo e(route('contact')); ?>"
                                                        class="btn-primary d-flex align-items-center justify-content-center h-100 w-100 text-color-light font-weight-semibold text-decoration-none text-uppercase custom-button-header-top">Contact
                                                        Us</a>
                                                </span>
                                            </li>
                                        </ul>
                                    </nav>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="header-container container bg-color-light">
                    <div class="header-row">
                        <div class="header-column header-column-logo">
                            <div class="header-row">
                                <div class="header-logo">
                                    <a href="<?php echo e(route('home')); ?>">
                                        <?php if(!empty($globalSettings['site_logo'])): ?>
                                            <img alt="<?php echo e($globalSettings['site_name'] ?? 'Tamio Capital'); ?>" width="123"
                                                height="32" src="<?php echo e(asset($globalSettings['site_logo'])); ?>">
                                        <?php else: ?>
                                            <img alt="Tamio" width="123" height="32"
                                                src="<?php echo e(asset('img/demos/business-consulting-2/logos/porto.png')); ?>">
                                        <?php endif; ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="header-column header-column-nav-menu justify-content-end">
                            <div class="header-row">
                                <div class="header-nav header-nav-links order-2 order-lg-1">
                                    <div
                                        class="header-nav-main header-nav-main-square header-nav-main-effect-1 header-nav-main-sub-effect-1">
                                        <nav class="collapse">
                                            <ul class="nav nav-pills" id="mainNav">
                                                <?php if(isset($header_menu) && $header_menu->rootItems->count() > 0): ?>
                                                    <?php $__currentLoopData = $header_menu->rootItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo $__env->make('layouts.partials.menu_item', ['item' => $item], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <li><a class="nav-link active" href="/">Home</a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </nav>
                                    </div>
                                    <button class="btn header-btn-collapse-nav" data-bs-toggle="collapse"
                                        data-bs-target=".header-nav-main nav">
                                        <i class="fas fa-bars"></i>
                                    </button>
                                </div>
                                <div
                                    class="header-nav-features header-nav-features-no-border header-nav-features-lg-show-border order-1 order-lg-2">
                                    <div class="header-nav-feature header-nav-features-search d-inline-flex">
                                        <a href="#" class="header-nav-features-toggle text-decoration-none"
                                            data-focus="headerSearch"><i
                                                class="fas fa-search header-nav-top-icon"></i></a>
                                        <div class="header-nav-features-dropdown" id="headerTopSearchDropdown">
                                            <form role="search" action="<?php echo e(route('search')); ?>" method="GET">
                                                <div class="simple-search input-group">
                                                    <input class="form-control text-1" id="headerSearch" name="q"
                                                        type="search" value="" placeholder="Search...">
                                                    <span class="input-group-btn">
                                                        <button class="btn" type="submit">
                                                            <i class="fa fa-search header-nav-top-icon"></i>
                                                        </button>
                                                    </span>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <div role="main" class="main">
            <?php echo $__env->yieldContent('content'); ?>
        </div>

        <style>
            body {
                font-family:
                    <?php echo $globalSettings['body_font_family'] ?? "'Open Sans', sans-serif"; ?>

                    !important;
                font-size:
                    <?php echo e($globalSettings['body_font_size'] ?? '14'); ?>

                    px !important;
            }

            #footer {
                background-color:
                    <?php echo e($globalSettings['footer_bg_color'] ?? '#383f48'); ?>

                    !important;
                <?php if(!empty($globalSettings['footer_font_family'])): ?>
                    font-family:
                        <?php echo $globalSettings['footer_font_family']; ?>

                        !important;
                <?php endif; ?>
                <?php if(!empty($globalSettings['footer_font_size'])): ?>
                    font-size:
                    <?php echo e($globalSettings['footer_font_size']); ?>

                    px !important;
                <?php endif; ?>
            }

            #footer p,
            #footer li,
            #footer span,
            #footer .text-color-grey,
            #footer .text-color-default {
                color:
                    <?php echo e($globalSettings['footer_text_color'] ?? '#999999'); ?>

                    !important;
            }

            #footer h5 {
                color:
                    <?php echo e($globalSettings['footer_title_color'] ?? '#E36159'); ?>

                    !important;
            }

            #footer a:not(.btn),
            #footer a:not(.btn) i {
                color:
                    <?php echo e($globalSettings['footer_link_color'] ?? '#E36159'); ?>

                    !important;
            }

            #footer .footer-copyright {
                background-color:
                    <?php echo e($globalSettings['copyright_bg_color'] ?? 'rgba(0, 0, 0, 0.1)'); ?>

                    !important;
            }
        </style>
        <footer id="footer" class="m-0 border-0 overflow-hidden"
            style="background-color: <?php echo e($globalSettings['footer_bg_color'] ?? '#383f48'); ?>;">
            <div class="container">
                <div class="row py-5 my-4">
                    <div class="col-md-6 col-lg-3 mb-4 mb-lg-0">
                        <h5 class="text-3 mb-3 fw-bold">ABOUT US</h5>
                        <?php if(isset($globalSettings['site_logo'])): ?>
                            <a href="<?php echo e(url('/')); ?>" class="d-inline-block mb-3">
                                <img alt="<?php echo e($globalSettings['site_name'] ?? 'Tamio Capital'); ?>" width="150"
                                    src="<?php echo e(asset($globalSettings['site_logo'])); ?>">
                            </a>
                        <?php endif; ?>
                        <p class="pe-1">
                            <?php echo e($globalSettings['footer_text'] ?? 'Tamio Capital Corporation is a private equity firm that partners with exceptional businesses.'); ?>

                        </p>
                    </div>
                    <div class="col-md-6 col-lg-3 mb-4 mb-lg-0">
                        <h5 class="text-3 mb-3 fw-bold">QUICK LINKS</h5>
                        <ul class="list list-icons list-icons-sm text-2">
                            <li><i class="fas fa-angle-right"></i> <a href="<?php echo e(route('home')); ?>"
                                    class="link-hover-style-1 ms-1">Home</a></li>
                            <li><i class="fas fa-angle-right"></i> <a href="<?php echo e(route('approach')); ?>"
                                    class="link-hover-style-1 ms-1">Approach</a></li>
                            <li><i class="fas fa-angle-right"></i> <a href="<?php echo e(route('team')); ?>"
                                    class="link-hover-style-1 ms-1">Team</a></li>
                            <li><i class="fas fa-angle-right"></i> <a href="<?php echo e(route('contact')); ?>"
                                    class="link-hover-style-1 ms-1">Contact Us</a></li>
                        </ul>
                    </div>
                    <div class="col-md-6 col-lg-3 mb-4 mb-lg-0">
                        <h5 class="text-3 mb-3 fw-bold">SECTORS</h5>
                        <ul class="list list-icons list-icons-sm text-2">
                            <li><i class="fas fa-angle-right"></i> <a href="#"
                                    class="link-hover-style-1 ms-1">Technology</a></li>
                            <li><i class="fas fa-angle-right"></i> <a href="#"
                                    class="link-hover-style-1 ms-1">Consulting</a></li>
                            <li><i class="fas fa-angle-right"></i> <a href="#"
                                    class="link-hover-style-1 ms-1">Finance</a></li>
                        </ul>
                    </div>
                    <div class="col-md-6 col-lg-3 mb-4 mb-lg-0">
                        <h5 class="text-3 mb-3 fw-bold">CONTACT INFO</h5>
                        <ul class="list list-icons list-icons-sm text-2">
                            <li class="mb-1"><i class="fas fa-map-marker-alt text-color-primary"></i> <span
                                    class="ms-1"><?php echo e($globalSettings['contact_address'] ?? 'Address Override'); ?></span>
                            </li>
                            <li class="mb-1"><i class="fas fa-envelope text-color-primary"></i> <a
                                    href="mailto:<?php echo e($globalSettings['contact_email'] ?? ''); ?>" class="ms-1"><?php echo e($globalSettings['contact_email'] ?? 'info@tamio-capital.com'); ?></a></li>
                            <li class="mb-1"><i class="fas fa-phone text-color-primary"></i> <a
                                    href="tel:<?php echo e($globalSettings['contact_phone'] ?? ''); ?>"
                                    class="ms-1"><?php echo e($globalSettings['contact_phone'] ?? '(800) 123-4567'); ?></a></li>
                        </ul>
                        <ul class="social-icons custom-social-icons mt-4">
                            <?php if(isset($globalSettings['social_facebook'])): ?>
                                <li class="social-icons-facebook">
                                    <a class="custom-bg-color-light-grey" href="<?php echo e($globalSettings['social_facebook']); ?>"
                                        target="_blank" title="Facebook">
                                        <i class="fab fa-facebook-f text-4 font-weight-semibold text-color-secondary"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isset($globalSettings['social_twitter'])): ?>
                                <li class="social-icons-twitter">
                                    <a class="custom-bg-color-light-grey" href="<?php echo e($globalSettings['social_twitter']); ?>"
                                        target="_blank" title="Twitter">
                                        <i class="fab fa-twitter text-4 font-weight-semibold text-color-secondary"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isset($globalSettings['social_linkedin'])): ?>
                                <li class="social-icons-linkedin">
                                    <a class="custom-bg-color-light-grey" href="<?php echo e($globalSettings['social_linkedin']); ?>"
                                        target="_blank" title="LinkedIn">
                                        <i class="fab fa-linkedin-in text-4 font-weight-semibold text-color-secondary"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isset($globalSettings['social_instagram'])): ?>
                                <li class="social-icons-instagram">
                                    <a class="custom-bg-color-light-grey" href="<?php echo e($globalSettings['social_instagram']); ?>"
                                        target="_blank" title="Instagram">
                                        <i class="fab fa-instagram text-4 font-weight-semibold text-color-secondary"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <?php if(isset($globalSettings['social_youtube'])): ?>
                                <li class="social-icons-youtube">
                                    <a class="custom-bg-color-light-grey" href="<?php echo e($globalSettings['social_youtube']); ?>"
                                        target="_blank" title="YouTube">
                                        <i class="fab fa-youtube text-4 font-weight-semibold text-color-secondary"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="footer-copyright container bg-color-quaternary">
                <div class="row">
                    <div class="col-lg-12 text-center m-0">
                        <p class="text-color-grey">Tamio Capital. © <?php echo e(date('Y')); ?>. All Rights Reserved</p>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <!-- Vendor -->
    <script src="<?php echo e(asset('vendor/plugins/js/plugins.min.js')); ?>"></script>

    <!-- Theme Base, Components and Settings -->
    <script src="<?php echo e(asset('js/theme.js')); ?>"></script>

    <!-- Demo -->
    <script src="<?php echo e(asset('js/demos/demo-business-consulting-2.js')); ?>"></script>

    <!-- Theme Custom -->
    <script src="<?php echo e(asset('js/custom.js')); ?>"></script>

    <!-- Theme Initialization Files -->
    <script src="<?php echo e(asset('js/theme.init.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\laragon\www\tamio-capital\resources\views/layouts/app.blade.php ENDPATH**/ ?>