

<?php $__env->startSection('content'); ?>
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            <?php echo e($page->title ?? 'Portfolio'); ?>

                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="active"><?php echo e($page->title ?? 'Portfolio'); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <?php
            $introSection = $page ? $page->sections->firstWhere('section_identifier', 'portfolio_intro') : null;
            $content = $introSection ? ($introSection->content ?? []) : [];
        ?>

        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-4 pt-3 pt-lg-0">
                    <div class="card border-radius-0 box-shadow-1 border-0 me-lg-3 p-3 mb-4 mb-lg-0">
                        <img src="<?php echo e(asset($content['image'] ?? 'img/demos/business-consulting-2/bg/bg-1.jpg')); ?>"
                            class="img-fluid border-radius-0" alt="">
                    </div>
                </div>
                <div class="col-lg-8 pt-3 pt-lg-0">
                    <?php if(!empty($content['text'])): ?>
                        <p class="text-4 line-height-9 appear-animation" data-appear-animation="fadeIn"
                            data-appear-animation-delay="100"><?php echo e($content['text']); ?></p>
                    <?php else: ?>
                        <p class="text-4 line-height-9 appear-animation" data-appear-animation="fadeIn"
                            data-appear-animation-delay="100">We take pride in the success of our partners...</p>
                    <?php endif; ?>

                    <div class="counters custom-counters mt-5 d-flex">
                        <div class="counter counter-primary appear-animation" data-appear-animation="fadeInUpShorter"
                            data-appear-animation-delay="1000">
                            <strong data-to="<?php echo e($companies->count()); ?>" data-append="+">0</strong>
                            <label class="text-color-primary font-weight-bold">Portfolio Companies</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container py-2">
            <ul class="nav nav-pills sort-source sort-source-style-3 justify-content-center" data-sort-id="portfolio"
                data-option-key="filter" data-plugin-options="{'layoutMode': 'fitRows', 'filter': '*'}">
                <li class="nav-item active" data-option-value="*"><a class="nav-link text-1 text-uppercase active"
                        href="#">Show All</a></li>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item" data-option-value=".category-<?php echo e($category->id); ?>"><a
                            class="nav-link text-1 text-uppercase" href="#"><?php echo e($category->name); ?></a></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>

        <section class="real-word-stories bg-color-quaternary overflow-hidden p-relative pt-5 pb-4">
            <div class="container">
                <div class="row justify-content-between pt-5 mb-2 sort-destination" data-sort-id="portfolio">
                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 position-relative isotope-item category-<?php echo e($company->category_id); ?>">
                            <div class="custom-testimonial-container bg-color-light mb-5">
                                <div class="testimonial custom-testimonial testimonial-style-2 mb-0">
                                    <div
                                        class="d-none d-sm-flex align-items-center justify-content-center custom-testimonial-right bg-color-light p-absolute z-index-1">
                                        <?php if($company->logo): ?>
                                            <img src="<?php echo e(Storage::url($company->logo)); ?>" alt="<?php echo e($company->name); ?>"
                                                style="max-width: 100px; max-height: 100px;">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('img/demos/business-consulting-2/logos/case-logo-1.png')); ?>"
                                                alt="<?php echo e($company->name); ?>">
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('portfolio.show', $company->id)); ?>"
                                            class="d-block btn btn-primary custom-button-testimonial-right text-center text-uppercase text-decoration-none border-0 p-0 font-weight-semibold p-absolute">details</a>
                                    </div>
                                    <blockquote class="px-0 pb-5">
                                        <h4 class="text-color-secondary font-weight-bold text-start"><?php echo e($company->name); ?></h4>
                                        <p class="mb-0 text-start text-3"><?php echo e(Str::limit($company->description, 100)); ?></p>
                                    </blockquote>
                                    <div class="testimonial-arrow-down"></div>
                                    <div class="testimonial-author d-flex flex-row justify-content-start align-items-center">
                                        <p><strong
                                                class="font-weight-extra-bold text-start text-color-secondary mb-1"><?php echo e($company->sector); ?></strong><span
                                                class="text-uppercase text-start"><?php echo e(optional($categories->where('id', $company->category_id)->first())->name); ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/portfolio.blade.php ENDPATH**/ ?>