<?php
    $hasChildren = $item->children->count() > 0;

    // Resolve URL: Dynamic Page or Static URL
    $url = $item->page_id ? url($item->page->slug) : ($item->url ?? '#');
    if ($url == url('/')) {
        $isActive = request()->path() == '/';
    } else {
        $path = parse_url($url, PHP_URL_PATH);
        $isActive = $path ? request()->is(ltrim($path, '/') . '*') : false;
    }
?>

<li class="<?php echo e($hasChildren ? 'dropdown' : ''); ?> <?php echo e($isActive ? 'active' : ''); ?>">
    <a class="<?php echo e($hasChildren ? 'dropdown-item dropdown-toggle' : 'nav-link'); ?> <?php echo e($isActive ? 'active' : ''); ?>"
        href="<?php echo e($url); ?>" target="<?php echo e($item->target ?? '_self'); ?>">
        <?php echo e($item->title); ?>

    </a>
    <?php if($hasChildren): ?>
        <ul class="dropdown-menu">
            <?php $__currentLoopData = $item->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo $__env->make('layouts.partials.menu_item', ['item' => $child], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    <?php endif; ?>
</li><?php /**PATH C:\laragon\www\tamio-capital\resources\views/layouts/partials/menu_item.blade.php ENDPATH**/ ?>