

<?php $__env->startSection('title', $page->seo_title ?? $page->title); ?>
<?php $__env->startSection('meta_description', $page->seo_description ?? ''); ?>

<?php $__env->startSection('content'); ?>

    <div role="main" class="main">
        
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            <?php echo e($page->title); ?>

                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                            <li class="active"><?php echo e($page->title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        
        <?php if($page->sections->count() > 0): ?>
            <?php $__currentLoopData = $page->sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    // Determine partial path based on identifier or type if available
                    // For now, we will assume a generic render or simple HTML output if 'content' has body
                    $content = $section->content ?? [];
                ?>

                <div class="container py-5">
                    <?php if(!empty($content['subheading'])): ?>
                        <div class="row align-items-center pb-3">
                            <div class="col">
                                <p class="text-4 line-height-9"><?php echo e($content['subheading']); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col">
                            <?php if(!empty($content['body'])): ?>
                                <?php echo $content['body']; ?>

                            <?php endif; ?>

                            <?php if(!empty($content['image'])): ?>
                                <div class="mt-4">
                                    <img src="<?php echo e(asset($content['image'])); ?>" class="img-fluid" alt="<?php echo e($page->title); ?>">
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <div class="container py-5">
                <div class="alert alert-info">
                    This page has no content sections yet. Please add them in the Admin Panel.
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/page.blade.php ENDPATH**/ ?>