

<?php $__env->startSection('content'); ?>
    <div class="container-fluid p-0">
        <div class="row mb-2 mb-xl-3">
            <div class="col-auto d-none d-sm-block">
                <h3><strong>Menus</strong> Manager</h3>
            </div>
            <div class="col-auto ms-auto text-end mt-n1">
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createMenuModal">Create New
                    Menu</button>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Location</th>
                            <th>Items</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($menu->name); ?></td>
                                <td>
                                    <?php if($menu->location): ?>
                                        <span class="badge bg-success"><?php echo e($menu->location); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-light text-dark">Unassigned</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($menu->items_count); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.menus.builder', $menu->id)); ?>"
                                        class="btn btn-sm btn-info text-white"><i data-feather="edit"></i> Builder</a>
                                    <form action="<?php echo e(route('admin.menus.destroy', $menu->id)); ?>" method="POST" class="d-inline"
                                        onsubmit="return confirm('Delete this menu?');">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-danger"><i data-feather="trash-2"></i></button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="createMenuModal" tabindex="-1">
        <div class="modal-dialog">
            <form action="<?php echo e(route('admin.menus.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Create Menu</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Menu Name</label>
                            <input type="text" name="name" class="form-control" required placeholder="e.g. Header Main">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Location (Optional)</label>
                            <select name="location" class="form-select">
                                <option value="">-- Select Location --</option>
                                <option value="header">Header Main Menu</option>
                                <option value="footer_links">Footer Quick Links</option>
                                <option value="footer_legal">Footer Legal</option>
                            </select>
                            <div class="form-text">Unique locations defined by the theme.</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Create Menu</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\tamio-capital\resources\views/admin/menus/index.blade.php ENDPATH**/ ?>