<?php

use Illuminate\Support\Facades\Route;

// Public Routes
Route::redirect('/login', '/admin/login');
Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/approach', [App\Http\Controllers\PageController::class, 'approach'])->name('approach');
Route::get('/portfolio', [App\Http\Controllers\PortfolioController::class, 'index'])->name('portfolio');
Route::get('/portfolio/{slug}', [App\Http\Controllers\PortfolioController::class, 'show'])->name('portfolio.show');
Route::get('/team', [App\Http\Controllers\TeamController::class, 'index'])->name('team');
Route::get('/team/{slug}', [App\Http\Controllers\TeamController::class, 'show'])->name('team.show');
Route::get('/careers', [App\Http\Controllers\CareerController::class, 'index'])->name('careers');
Route::get('/news', [App\Http\Controllers\NewsController::class, 'index'])->name('news.index');
Route::get('/news/{slug}', [App\Http\Controllers\NewsController::class, 'show'])->name('news.show');
Route::get('/services/{slug}', [App\Http\Controllers\Public\ServiceController::class, 'show'])->name('services.show');
Route::get('/contact', [App\Http\Controllers\PageController::class, 'contact'])->name('contact');
Route::post('/contact', [App\Http\Controllers\Public\ContactController::class, 'store'])->name('contact.store');
Route::post('/careers/apply', [App\Http\Controllers\Public\JobApplicationController::class, 'store'])->name('careers.apply');
Route::post('/newsletter', [App\Http\Controllers\Public\NewsletterController::class, 'store'])->name('newsletter.subscribe');
Route::get('/search', [App\Http\Controllers\SearchController::class, 'index'])->name('search');
Route::get('/sitemap.xml', [App\Http\Controllers\SitemapController::class, 'index'])->name('sitemap');
Route::get('/{slug}', [App\Http\Controllers\PageController::class, 'show'])->name('page.show');

// Admin Routes
Route::prefix('admin')->group(function () {
    Route::redirect('/', '/admin/login');
    Route::get('/login', [App\Http\Controllers\Admin\Auth\LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [App\Http\Controllers\Admin\Auth\LoginController::class, 'login']);
    Route::post('/logout', [App\Http\Controllers\Admin\Auth\LoginController::class, 'logout'])->name('logout');

    // Password Reset Routes...
    Route::get('password/reset', [App\Http\Controllers\Admin\Auth\ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
    Route::post('password/email', [App\Http\Controllers\Admin\Auth\ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
    Route::get('password/reset/{token}', [App\Http\Controllers\Admin\Auth\ResetPasswordController::class, 'showResetForm'])->name('password.reset');
    Route::post('password/reset', [App\Http\Controllers\Admin\Auth\ResetPasswordController::class, 'reset'])->name('password.update');

    Route::middleware('auth')->group(function () {
        Route::get('/dashboard', [App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('admin.dashboard');

        // Settings
        Route::get('/settings', [App\Http\Controllers\Admin\SettingController::class, 'edit'])->name('admin.settings.edit');
        Route::post('/settings', [App\Http\Controllers\Admin\SettingController::class, 'update'])->name('admin.settings.update');

        // Pages
        Route::get('/pages', [App\Http\Controllers\Admin\PageController::class, 'index'])->name('admin.pages.index');
        Route::get('/pages/{id}/edit', [App\Http\Controllers\Admin\PageController::class, 'edit'])->name('admin.pages.edit');
        Route::post('/pages/{id}', [App\Http\Controllers\Admin\PageController::class, 'update'])->name('admin.pages.update');

        // Explicit POST route for section updates - Defined here to avoid group naming confusion
        Route::post('pages/{page}/sections/{section}/update-content', [App\Http\Controllers\Admin\PageSectionController::class, 'update'])->name('admin.pages.sections.update_post');

        // Page Sections
        Route::prefix('pages/{page}')->name('admin.pages.')->group(function () {
            Route::post('sections/reorder', [App\Http\Controllers\Admin\PageSectionController::class, 'reorder'])->name('sections.reorder');
            Route::post('sections/{section}/toggle-status', [App\Http\Controllers\Admin\PageSectionController::class, 'toggleStatus'])->name('sections.toggle-status');
            Route::resource('sections', App\Http\Controllers\Admin\PageSectionController::class)->except(['show']);
        });

        // Portfolio Categories
        Route::resource('portfolio-categories', App\Http\Controllers\Admin\PortfolioCategoryController::class, ['as' => 'admin']);

        // Portfolio Companies
        Route::resource('portfolio', App\Http\Controllers\Admin\PortfolioController::class, ['as' => 'admin']);

        // Team
        Route::resource('team', App\Http\Controllers\Admin\TeamController::class, ['as' => 'admin']);

        // Careers
        Route::resource('careers/jobs', App\Http\Controllers\Admin\JobController::class, ['as' => 'admin.careers']);
        Route::get('careers/applications', [App\Http\Controllers\Admin\ApplicationController::class, 'index'])->name('admin.careers.applications.index');

        // News
        Route::resource('news', App\Http\Controllers\Admin\NewsController::class, ['as' => 'admin']);

        // Services
        Route::resource('services', App\Http\Controllers\Admin\ServiceController::class, ['as' => 'admin']);

        // Newsletter
        Route::get('newsletter', [App\Http\Controllers\Admin\NewsletterController::class, 'index'])->name('admin.newsletter.index');
        Route::get('newsletter/export', [App\Http\Controllers\Admin\NewsletterController::class, 'export'])->name('admin.newsletter.export');
        // Media Library
        Route::get('media', [App\Http\Controllers\Admin\MediaController::class, 'index'])->name('admin.media.index');
        Route::post('media', [App\Http\Controllers\Admin\MediaController::class, 'store'])->name('admin.media.store');
        Route::post('/media/upload-video', [App\Http\Controllers\Admin\MediaController::class, 'uploadVideo'])->name('admin.media.upload-video');
        Route::post('/media/rename', [App\Http\Controllers\Admin\MediaController::class, 'rename'])->name('admin.media.rename');
        Route::delete('media', [App\Http\Controllers\Admin\MediaController::class, 'destroy'])->name('admin.media.destroy');

        // Menus
        Route::get('menus', [App\Http\Controllers\Admin\MenuController::class, 'index'])->name('admin.menus.index');
        Route::post('menus', [App\Http\Controllers\Admin\MenuController::class, 'store'])->name('admin.menus.store');
        Route::delete('menus/{menu}', [App\Http\Controllers\Admin\MenuController::class, 'destroy'])->name('admin.menus.destroy');
        Route::get('menus/{menu}/builder', [App\Http\Controllers\Admin\MenuController::class, 'builder'])->name('admin.menus.builder');
        Route::post('menus/{menu}/store-item', [App\Http\Controllers\Admin\MenuController::class, 'storeItem'])->name('admin.menus.store-item');
        Route::post('menus/{menu}/structure', [App\Http\Controllers\Admin\MenuController::class, 'updateStructure'])->name('admin.menus.update-structure');
        Route::put('menus/items/{item}', [App\Http\Controllers\Admin\MenuController::class, 'updateItem'])->name('admin.menus.items.update');
        Route::delete('menus/items/{item}', [App\Http\Controllers\Admin\MenuController::class, 'destroyItem'])->name('admin.menus.items.destroy');

        // Global Settings
        Route::get('settings', [App\Http\Controllers\Admin\SettingController::class, 'edit'])->name('admin.settings.edit');
        Route::post('settings', [App\Http\Controllers\Admin\SettingController::class, 'update'])->name('admin.settings.update');
    });
});
