@extends('layouts.app')

@section('title', $member->name . ' - Tamio Capital')

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">{{ $member->name }}
                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li><a href="{{ route('team') }}">Team</a></li>
                            <li class="active">{{ $member->name }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <div class="container py-5">
            <div class="row">
                <div class="col-lg-4">
                    <div class="card border-0 border-radius-0 box-shadow-1 mb-4">
                        <div class="card-body p-4">
                            <div class="text-center">
                                @if($member->photo)
                                    <img src="{{ Storage::url($member->photo) }}" class="img-fluid rounded-circle mb-4"
                                        width="200" height="200" alt="{{ $member->name }}" style="object-fit: cover;">
                                @else
                                    <img src="{{ asset('img/avatars/default-avatar.png') }}"
                                        class="img-fluid rounded-circle mb-4" width="200" height="200"
                                        alt="{{ $member->name }}">
                                @endif
                                <h2 class="font-weight-bold text-5 mb-1">{{ $member->name }}</h2>
                                <p class="text-uppercase text-1 text-color-default mb-3">{{ $member->title }}</p>
                            </div>
                            <hr class="my-4">
                            <ul class="list list-icons list-icons-style-3 mt-3">
                                @if($member->phone)
                                    <li><i class="fas fa-phone text-color-primary"></i> <a href="tel:{{ $member->phone }}"
                                            class="text-color-dark">{{ $member->phone }}</a></li>
                                @endif
                                @if($member->email)
                                    <li><i class="fas fa-envelope text-color-primary"></i> <a href="mailto:{{ $member->email }}"
                                            class="text-color-dark">{{ $member->email }}</a></li>
                                @endif
                                @if($member->linkedin_url)
                                    <li><i class="fab fa-linkedin text-color-primary"></i> <a href="{{ $member->linkedin_url }}"
                                            target="_blank" class="text-color-dark">LinkedIn Profile</a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <h3 class="font-weight-bold text-4 mb-4">Biography</h3>
                    <div class="text-3-5 line-height-9">
                        {!! $member->bio !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection