@extends('layouts.app')

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">Team</h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li class="active">Team</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-8">
                    @php
                        $introSection = $page ? $page->sections->firstWhere('section_identifier', 'team_intro') : null;
                        $content = $introSection ? ($introSection->content ?? []) : [];
                    @endphp
                    @if(!empty($content['text']))
                        <p class="text-4 line-height-9 appear-animation" data-appear-animation="fadeIn"
                            data-appear-animation-delay="100">{{ $content['text'] }}</p>
                    @else
                        <p class="text-4 line-height-9 appear-animation" data-appear-animation="fadeIn"
                            data-appear-animation-delay="100">Meet the dedicated team behind Tamio Capital. Our experts bring
                            years of experience in finance, strategy, and operations to deliver exceptional results for our
                            clients.</p>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col py-5">
                    <hr class="m-0">
                </div>
            </div>
            <div class="row">
                <div class="col">
                    <p class="text-uppercase font-weight-semibold mb-1 text-color-primary appear-animation"
                        data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100"><span
                            class="line-pre-title bg-color-primary"></span>Who We Are</p>
                    <h2 class="text-color-secondary font-weight-bold text-capitalize mb-4 custom-letter-spacing-2 custom-text-1 appear-animation"
                        data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">Experienced Team</h2>
                </div>
            </div>
            <div class="row">
                @foreach($team as $member)
                    <div class="col-md-6 pt-3 mb-3 appear-animation" data-appear-animation="fadeIn"
                        data-appear-animation-delay="100">
                        <div class="row align-items-center no-gutters">
                            <div class="col-lg-5">
                                <div class="card border-radius-0 box-shadow-1 border-0 me-lg-4 p-3 mb-3 mb-lg-0">
                                    <a href="#" class="d-block p-relative">
                                        @if($member->photo)
                                            <img src="{{ Storage::url($member->photo) }}" class="img-fluid border-radius-0"
                                                alt="{{ $member->name }}">
                                        @else
                                            <img src="{{ asset('img/team/team-1.jpg') }}" class="img-fluid border-radius-0"
                                                alt="{{ $member->name }}">
                                        @endif
                                    </a>
                                </div>
                            </div>
                            <div class="col-lg-7 ps-2 ps-lg-0">
                                <p class="mb-0 text-uppercase">{{ $member->title }}</p>
                                <h4 class="mb-3 text-5 font-weight-bold"><a class="text-color-tertiary"
                                        href="#">{{ $member->name }}</a></h4>
                                <p class="mb-3">{{ Str::limit($member->bio, 100) }}</p>
                                @if($member->linkedin_url)
                                    <a href="{{ $member->linkedin_url }}" target="_blank"
                                        class="font-weight-bold text-uppercase text-decoration-none d-block mt-3">LinkedIn
                                        Profile</a>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection