@extends('layouts.app')

@section('title', $service->title . ' - Tamio Capital')
@section('meta_description', Str::limit(strip_tags($service->short_description), 160))

@section('content')

    <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
        <div class="container">
            <div class="row">
                <div class="col-md-12 align-self-center p-static order-2 text-center">
                    <h1 class="text-dark font-weight-bold text-8">{{ $service->title }}</h1>
                </div>
                <div class="col-md-12 align-self-center order-1">
                    <ul class="breadcrumb d-block text-center">
                        <li><a href="{{ route('home') }}">Home</a></li>
                        <li class="active">Services</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <div class="container py-4">
        <div class="row">
            <div class="col-lg-12 appear-animation" data-appear-animation="fadeInUpShorter"
                data-appear-animation-delay="300">
                <div class="owl-carousel owl-theme nav-inside nav-inside-edge nav-squared nav-with-transparency nav-dark nav-lg d-block overflow-hidden"
                    data-plugin-options="{'items': 1, 'margin': 10, 'loop': false, 'nav': false, 'dots': false, 'autoHeight': true}"
                    style="height: auto;">
                    <div>
                        @if($service->image)
                            <div class="img-thumbnail border-0 p-0 d-block">
                                <img src="{{ asset($service->image) }}" class="img-fluid border-radius-0"
                                    alt="{{ $service->title }}">
                            </div>
                        @endif
                    </div>
                </div>

                <p class="font-weight-bold text-4 text-color-dark mt-4">{!! nl2br(e($service->short_description)) !!}</p>

                <div class="post-content ms-0">
                    {!! $service->content !!}
                </div>
            </div>
        </div>
    </div>

@endsection