@extends('layouts.app')

@section('title', 'Search Results')

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern bg-color-light-scale-1 page-header-md">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 align-self-center p-static order-2 text-center">
                        <h1 class="text-dark font-weight-bold text-8">Search Results</h1>
                        <span class="sub-title text-2">Results for "{{ $query }}"</span>
                    </div>
                    <div class="col-md-12 align-self-center order-1">
                        <ul class="breadcrumb d-block text-center">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li class="active">Search</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        <div class="container py-5">
            <div class="row">
                <div class="col">
                    @if($results->count() > 0)
                        <ul class="simple-post-list m-0">
                            @foreach($results as $result)
                                <li>
                                    <div class="post-info">
                                        <span class="text-1 d-block text-color-primary">{{ $result->type }}</span>
                                        <h4 class="font-weight-bold mb-0">
                                            <a href="{{ $result->url }}"
                                                class="text-decoration-none text-dark">{{ $result->title }}</a>
                                        </h4>
                                        <p class="mb-0">{{ Str::limit(strip_tags($result->description), 150) }}</p>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="alert alert-info">
                            No results found for <strong>{{ $query }}</strong>.
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection