@extends('layouts.app')

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            {{ $company->name }}</h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li><a href="{{ route('portfolio') }}">Portfolio</a></li>
                            <li class="active">{{ Str::limit($company->name, 20) }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <div class="container py-5">
            <div class="row">
                <div class="col">
                    <div class="row">
                        <div class="col-lg-7">
                            <p class="text-4 mb-4 mt-2">{!! nl2br(e($company->description)) !!}</p>

                            @if($company->services)
                                <h4 class="font-weight-bold text-color-secondary mt-4">Services Provided</h4>
                                <ul class="list list-icons list-primary mt-3">
                                    @foreach(json_decode($company->services) as $service)
                                        <li><i class="fas fa-check"></i> {{ $service }}</li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        <div class="col-lg-5">
                            @if($company->logo)
                                <div class="card border-0 border-radius-0 mb-4">
                                    <img src="{{ Storage::url($company->logo) }}" class="img-fluid border-radius-0"
                                        alt="{{ $company->name }}">
                                </div>
                            @endif

                            <div class="card border-0 border-radius-0 bg-color-light box-shadow-1">
                                <div class="card-body">
                                    <h4 class="card-title mb-4 font-weight-bold text-color-secondary">Project Details</h4>
                                    <ul class="list list-unstyled mb-0">
                                        <li class="mb-2"><strong class="text-color-dark">Client:</strong>
                                            {{ $company->name }}</li>
                                        <li class="mb-2"><strong class="text-color-dark">Sector:</strong>
                                            {{ $company->sector }}</li>
                                        @if($company->website_url)
                                            <li class="mb-2"><strong class="text-color-dark">Website:</strong> <a
                                                    href="{{ $company->website_url }}"
                                                    target="_blank">{{ $company->website_url }}</a></li>
                                        @endif
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection