@extends('layouts.app')

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            {{ $page->title ?? 'Portfolio' }}
                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li class="active">{{ $page->title ?? 'Portfolio' }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        @php
            $introSection = $page ? $page->sections->firstWhere('section_identifier', 'portfolio_intro') : null;
            $content = $introSection ? ($introSection->content ?? []) : [];
        @endphp

        <div class="container py-5">
            <div class="row align-items-center">
                <div class="col-lg-4 pt-3 pt-lg-0">
                    <div class="card border-radius-0 box-shadow-1 border-0 me-lg-3 p-3 mb-4 mb-lg-0">
                        <img src="{{ asset($content['image'] ?? 'img/demos/business-consulting-2/bg/bg-1.jpg') }}"
                            class="img-fluid border-radius-0" alt="">
                    </div>
                </div>
                <div class="col-lg-8 pt-3 pt-lg-0">
                    @if(!empty($content['text']))
                        <p class="text-4 line-height-9 appear-animation" data-appear-animation="fadeIn"
                            data-appear-animation-delay="100">{{ $content['text'] }}</p>
                    @else
                        <p class="text-4 line-height-9 appear-animation" data-appear-animation="fadeIn"
                            data-appear-animation-delay="100">We take pride in the success of our partners...</p>
                    @endif

                    <div class="counters custom-counters mt-5 d-flex">
                        <div class="counter counter-primary appear-animation" data-appear-animation="fadeInUpShorter"
                            data-appear-animation-delay="1000">
                            <strong data-to="{{ $companies->count() }}" data-append="+">0</strong>
                            <label class="text-color-primary font-weight-bold">Portfolio Companies</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container py-2">
            <ul class="nav nav-pills sort-source sort-source-style-3 justify-content-center" data-sort-id="portfolio"
                data-option-key="filter" data-plugin-options="{'layoutMode': 'fitRows', 'filter': '*'}">
                <li class="nav-item active" data-option-value="*"><a class="nav-link text-1 text-uppercase active"
                        href="#">Show All</a></li>
                @foreach($categories as $category)
                    <li class="nav-item" data-option-value=".category-{{ $category->id }}"><a
                            class="nav-link text-1 text-uppercase" href="#">{{ $category->name }}</a></li>
                @endforeach
            </ul>
        </div>

        <section class="real-word-stories bg-color-quaternary overflow-hidden p-relative pt-5 pb-4">
            <div class="container">
                <div class="row justify-content-between pt-5 mb-2 sort-destination" data-sort-id="portfolio">
                    @foreach($companies as $company)
                        <div class="col-lg-6 position-relative isotope-item category-{{ $company->category_id }}">
                            <div class="custom-testimonial-container bg-color-light mb-5">
                                <div class="testimonial custom-testimonial testimonial-style-2 mb-0">
                                    <div
                                        class="d-none d-sm-flex align-items-center justify-content-center custom-testimonial-right bg-color-light p-absolute z-index-1">
                                        @if($company->logo)
                                            <img src="{{ Storage::url($company->logo) }}" alt="{{ $company->name }}"
                                                style="max-width: 100px; max-height: 100px;">
                                        @else
                                            <img src="{{ asset('img/demos/business-consulting-2/logos/case-logo-1.png') }}"
                                                alt="{{ $company->name }}">
                                        @endif
                                        <a href="{{ route('portfolio.show', $company->id) }}"
                                            class="d-block btn btn-primary custom-button-testimonial-right text-center text-uppercase text-decoration-none border-0 p-0 font-weight-semibold p-absolute">details</a>
                                    </div>
                                    <blockquote class="px-0 pb-5">
                                        <h4 class="text-color-secondary font-weight-bold text-start">{{ $company->name }}</h4>
                                        <p class="mb-0 text-start text-3">{{ Str::limit($company->description, 100) }}</p>
                                    </blockquote>
                                    <div class="testimonial-arrow-down"></div>
                                    <div class="testimonial-author d-flex flex-row justify-content-start align-items-center">
                                        <p><strong
                                                class="font-weight-extra-bold text-start text-color-secondary mb-1">{{ $company->sector }}</strong><span
                                                class="text-uppercase text-start">{{ optional($categories->where('id', $company->category_id)->first())->name }}</span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    </div>
@endsection