@extends('layouts.app')

@section('title', $page->seo_title ?? $page->title)
@section('meta_description', $page->seo_description ?? '')

@section('content')

    <div role="main" class="main">
        {{-- Page Header (Hero) --}}
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            {{ $page->title }}
                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li class="active">{{ $page->title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        {{-- Dynamic Sections Loop --}}
        @if($page->sections->count() > 0)
            @foreach($page->sections as $section)
                @php
                    // Determine partial path based on identifier or type if available
                    // For now, we will assume a generic render or simple HTML output if 'content' has body
                    $content = $section->content ?? [];
                @endphp

                <div class="container py-5">
                    @if(!empty($content['subheading']))
                        <div class="row align-items-center pb-3">
                            <div class="col">
                                <p class="text-4 line-height-9">{{ $content['subheading'] }}</p>
                            </div>
                        </div>
                    @endif

                    <div class="row">
                        <div class="col">
                            @if(!empty($content['body']))
                                {!! $content['body'] !!}
                            @endif

                            @if(!empty($content['image']))
                                <div class="mt-4">
                                    <img src="{{ asset($content['image']) }}" class="img-fluid" alt="{{ $page->title }}">
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        @else
            <div class="container py-5">
                <div class="alert alert-info">
                    This page has no content sections yet. Please add them in the Admin Panel.
                </div>
            </div>
        @endif
    </div>
@endsection