@extends('layouts.app')

@section('title', $post->meta_title ?? $post->title)
@section('meta_description', $post->meta_description ?? Str::limit(strip_tags($post->content), 160))

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">{{ $post->title }}
                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li><a href="{{ route('news.index') }}">News</a></li>
                            <li class="active">{{ Str::limit($post->title, 20) }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-9">
                    <article>
                        <div class="card border-0 border-radius-0 mb-5 box-shadow-1">
                            <div class="card-body p-4 z-index-1">
                                <p class="text-uppercase text-1 mb-3 text-color-default">
                                    <time pubdate
                                        datetime="{{ $post->published_at }}">{{ \Carbon\Carbon::parse($post->published_at)->format('d M Y') }}</time>
                                </p>
                                @if($post->featured_image)
                                    <div class="post-image pb-4">
                                        <img class="card-img-top border-radius-0"
                                            src="{{ Storage::url($post->featured_image) }}" alt="{{ $post->title }}">
                                    </div>
                                @endif
                                <div class="card-body p-0 clearfix">
                                    @if(isset($post->logo))
                                        <div class="float-start me-4 mb-3" style="max-width: 250px;">
                                            <img src="{{ asset($post->logo) }}" class="img-fluid" alt="Partner Logo">
                                        </div>
                                    @endif
                                    {!! $post->content !!}
                                </div>
                            </div>
                        </div>
                    </article>
                </div>
                <div class="col-lg-3 pt-4 pt-lg-0">
                    <aside class="sidebar">
                        <div class="px-3 mb-4">
                            <a href="{{ route('news.index') }}" class="btn btn-secondary btn-sm w-100 mb-4">View All
                                Posts</a>
                        </div>

                        <h5 class="font-weight-bold pt-4">Search</h5>
                        <form action="{{ route('news.index') }}" method="GET">
                            <div class="input-group mb-3 pb-1">
                                <input class="form-control box-shadow-none text-1 border-0 bg-color-grey"
                                    placeholder="Search..." name="s" id="s" type="text">
                                <button type="submit" class="btn p-0 bg-color-grey border-0"><i
                                        class="fas fa-search m-2 text-color-dark"></i></button>
                            </div>
                        </form>

                        <h5 class="font-weight-bold pt-4">Recent Posts</h5>
                        <ul class="simple-post-list">
                            @foreach($recent_posts as $recent)
                                <li>
                                    <div class="post-image">
                                        <div class="img-thumbnail img-thumbnail-no-borders d-block">
                                            <a href="{{ route('news.show', $recent->slug) }}">
                                                <img src="{{ $recent->featured_image ? Storage::url($recent->featured_image) : asset('img/demos/business-consulting-2/blog/blog-1.jpg') }}"
                                                    class="border-radius-0" width="50" height="50" alt="{{ $recent->title }}"
                                                    style="object-fit: cover;">
                                            </a>
                                        </div>
                                    </div>
                                    <div class="post-info">
                                        <a href="{{ route('news.show', $recent->slug) }}"
                                            class="text-decoration-none text-color-dark">{{ Str::limit($recent->title, 40) }}</a>
                                        <div class="post-meta">
                                            {{ \Carbon\Carbon::parse($recent->published_at)->format('M d, Y') }}
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </aside>
                </div>
            </div>
        </div>
    </div>
@endsection