@extends('layouts.app')

@section('content')
    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">News & Insights
                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li class="active">News</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <div class="container py-5">
            <div class="row">
                <div class="col-lg-9">
                    @foreach($posts as $post)
                        <article>
                            <div class="card border-0 border-radius-0 mb-5 box-shadow-1">
                                <div class="card-body p-4 z-index-1">
                                    @if($post->featured_image)
                                        <a href="{{ route('news.show', $post->slug) }}">
                                            <img class="card-img-top border-radius-0 mb-3"
                                                src="{{ Storage::url($post->featured_image) }}" alt="{{ $post->title }}">
                                        </a>
                                    @endif
                                    <p class="text-uppercase text-1 mb-3 pt-1 text-color-default">
                                        <time pubdate
                                            datetime="{{ $post->published_at }}">{{ \Carbon\Carbon::parse($post->published_at)->format('d M Y') }}</time>
                                    </p>
                                    <div class="card-body p-0">
                                        <h4 class="card-title mb-3 text-5 font-weight-bold"><a class="text-color-secondary"
                                                href="{{ route('news.show', $post->slug) }}">{{ $post->title }}</a></h4>
                                        <p class="card-text mb-3">{!! Str::limit(strip_tags($post->content), 200) !!}</p>
                                        <a href="{{ route('news.show', $post->slug) }}"
                                            class="font-weight-bold text-uppercase text-decoration-none d-block mt-3">Read More
                                            +</a>
                                    </div>
                                </div>
                            </div>
                        </article>
                    @endforeach

                    <!-- Pagination logic would go here if we were using pagination() in controller -->
                </div>

                <div class="col-lg-3 pt-4 pt-lg-0">
                    <aside class="sidebar">
                        <h5 class="font-weight-bold pt-4">Search</h5>
                        <form action="{{ route('news.index') }}" method="GET">
                            <div class="input-group mb-3 pb-1">
                                <input class="form-control box-shadow-none text-1 border-0 bg-color-grey"
                                    placeholder="Search..." name="s" id="s" type="text" value="{{ request('s') }}">
                                <button type="submit" class="btn p-0 bg-color-grey border-0"><i
                                        class="fas fa-search m-2 text-color-dark"></i></button>
                            </div>
                        </form>

                        <h5 class="font-weight-bold pt-4">Recent Posts</h5>
                        <ul class="simple-post-list">
                            @foreach($recent_posts as $recent)
                                <li>
                                    <div class="post-image">
                                        <div class="img-thumbnail img-thumbnail-no-borders d-block">
                                            <a href="{{ route('news.show', $recent->slug) }}">
                                                <img src="{{ $recent->featured_image ? Storage::url($recent->featured_image) : asset('img/demos/business-consulting-2/blog/blog-1.jpg') }}"
                                                    class="border-radius-0" width="50" height="50" alt="{{ $recent->title }}"
                                                    style="object-fit: cover;">
                                            </a>
                                        </div>
                                    </div>
                                    <div class="post-info">
                                        <a href="{{ route('news.show', $recent->slug) }}"
                                            class="text-decoration-none text-color-dark">{{ Str::limit($recent->title, 40) }}</a>
                                        <div class="post-meta">
                                            {{ \Carbon\Carbon::parse($recent->published_at)->format('M d, Y') }}
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>

                        <div class="px-3 mb-4 mt-4">
                            <h3 class="text-color-secondary text-capitalize font-weight-bold text-5 m-0 mb-3">About</h3>
                            <p class="m-0">Insights, updates, and news from Tamio Capital.</p>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>
@endsection