@php
    $hasChildren = $item->children->count() > 0;

    // Resolve URL: Dynamic Page or Static URL
    $url = $item->page_id ? url($item->page->slug) : ($item->url ?? '#');
    if ($url == url('/')) {
        $isActive = request()->path() == '/';
    } else {
        $path = parse_url($url, PHP_URL_PATH);
        $isActive = $path ? request()->is(ltrim($path, '/') . '*') : false;
    }
@endphp

<li class="{{ $hasChildren ? 'dropdown' : '' }} {{ $isActive ? 'active' : '' }}">
    <a class="{{ $hasChildren ? 'dropdown-item dropdown-toggle' : 'nav-link' }} {{ $isActive ? 'active' : '' }}"
        href="{{ $url }}" target="{{ $item->target ?? '_self' }}">
        {{ $item->title }}
    </a>
    @if($hasChildren)
        <ul class="dropdown-menu">
            @foreach($item->children as $child)
                @include('layouts.partials.menu_item', ['item' => $child])
            @endforeach
        </ul>
    @endif
</li>