@extends('layouts.app')

@section('title', $page->seo_title ?? 'Home')
@section('meta_description', $page->seo_description ?? 'Tamio Capital Home')

@section('content')

    <div role="main" class="main">
        @foreach($page->sections as $section)
            @php 
                $content = $section->content ?? []; 
                $identifier = $section->section_identifier;
            @endphp

            @switch($identifier)
                {{-- 1. Hero Slider --}}
                @case('home_slider')
                    @php 
                        $slides = $content['slides'] ?? [];
                        // Logic to fix single slide
                        $slideCount = count($slides);
                        $carouselOptions = [
                            'autoplay' => true,
                            'autoplayTimeout' => 7000,
                            'loop' => $slideCount > 1,
                            'nav' => $slideCount > 1,
                            'dots' => $slideCount > 1,
                        ];
                    @endphp
                    @if(!empty($slides))
                    <div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs show-dots-sm show-dots-md nav-style-1 nav-inside nav-inside-plus nav-dark nav-lg nav-font-size-lg show-nav-hover bg-color-quaternary custom-slider-container mb-0"
                        data-plugin-options="{{ json_encode($carouselOptions) }}"
                        data-dynamic-height="['991px','991px','991px','750px','750px']" style="height: 991px;">
                        <div class="owl-stage-outer">
                            <div class="owl-stage">
                                @foreach($slides as $slide)
                                    <div class="owl-item position-relative overflow-hidden" style="min-height: 750px;">
                                        <div class="background-wrapper position-absolute top-0 start-0 w-100 h-100" style="z-index: 0;">
                                            @php
                                                $bgType = $slide['bg_type'] ?? 'image';
                                                $videoUrl = $slide['video_url'] ?? '';
                                                if (($slide['video_source'] ?? 'url') === 'file' && !empty($slide['video_file'])) {
                                                    $videoUrl = asset($slide['video_file']);
                                                }
                                            @endphp
                                            @if($bgType === 'video' && !empty($videoUrl))
                                                <video autoplay muted loop playsinline class="w-100 h-100" style="object-fit: cover;">
                                                    <source src="{{ $videoUrl }}" type="video/mp4">
                                                </video>
                                            @elseif($bgType === 'color')
                                                <div class="w-100 h-100" style="background-color: {{ $slide['bg_color'] ?? '#333' }};"></div>
                                            @else
                                                <div class="w-100 h-100"
                                                    style="background-image: url({{ asset($slide['image'] ?? 'img/slides/slide-1.jpg') }}); background-size: cover; background-position: center;">
                                                </div>
                                            @endif
                                        </div>
                                        @if($slide['overlay_enabled'] ?? true)
                                            <div class="position-absolute top-0 start-0 w-100 h-100"
                                                style="background-color: {{ $slide['overlay_color'] ?? '#000000' }}; opacity: {{ $slide['overlay_opacity'] ?? '0.5' }}; z-index: 1;">
                                            </div>
                                        @endif
                                        <div class="container position-relative z-index-3 h-100">
                                            <div class="row h-100 align-items-center {{ ($slide['align'] ?? 'text-center') == 'text-center' ? 'justify-content-center' : (($slide['align'] ?? '') == 'text-end' ? 'justify-content-end' : '') }}">
                                                <div class="col-lg-8 {{ $slide['align'] ?? 'text-center' }}">
                                                    @php
                                                        // Styles
                                                        $tStyle = [];
                                                        if(!empty($slide['title_font_family'])) $tStyle[] = "font-family: '{$slide['title_font_family']}' !important";
                                                        if(!empty($slide['title_font_size'])) $tStyle[] = "font-size: {$slide['title_font_size']}px !important";
                                                        if(!empty($slide['title_color'])) $tStyle[] = "color: {$slide['title_color']} !important";
                                                        if(!empty($slide['title_shadow_color'])) {
                                                            $x = $slide['title_shadow_x'] ?? 0; $y = $slide['title_shadow_y'] ?? 0; $b = $slide['title_shadow_blur'] ?? 0; $c = $slide['title_shadow_color'];
                                                            $tStyle[] = "text-shadow: {$x}px {$y}px {$b}px {$c} !important";
                                                        }
                                                        $tStyleStr = implode(';', $tStyle);
                                                        
                                                        $sStyle = [];
                                                        if(!empty($slide['subtitle_font_family'])) $sStyle[] = "font-family: '{$slide['subtitle_font_family']}' !important";
                                                        if(!empty($slide['subtitle_font_size'])) $sStyle[] = "font-size: {$slide['subtitle_font_size']}px !important";
                                                        if(!empty($slide['subtitle_color'])) $sStyle[] = "color: {$slide['subtitle_color']} !important";
                                                        if(!empty($slide['subtitle_shadow_color'])) {
                                                            $x = $slide['subtitle_shadow_x'] ?? 0; $y = $slide['subtitle_shadow_y'] ?? 0; $b = $slide['subtitle_shadow_blur'] ?? 0; $c = $slide['subtitle_shadow_color'];
                                                            $sStyle[] = "text-shadow: {$x}px {$y}px {$b}px {$c} !important";
                                                        }
                                                        $sStyleStr = implode(';', $sStyle);
                                                    @endphp
                                                    @if(($slide['title_visible'] ?? '1') && !empty($slide['title']))
                                                        <h2 class="text-color-primary font-weight-bold text-uppercase text-4 line-height-3 mb-2 appear-animation" style="{{ $tStyleStr }}" data-appear-animation="{{ $slide['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ $slide['animation_delay'] ?? '500' }}"><span class="line-pre-title bg-color-primary d-none d-lg-inline-block"></span>{{ $slide['title'] }}</h2>
                                                    @endif
                                                    @if(($slide['subtitle_visible'] ?? '1') && !empty($slide['subtitle']))
                                                        <h1 class="text-color-secondary font-weight-extra-bold text-10 line-height-2 mb-3 appear-animation" style="{{ $sStyleStr }}" data-appear-animation="{{ $slide['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($slide['animation_delay'] ?? '500') + 250 }}">{{ $slide['subtitle'] }}</h1>
                                                    @endif
                                                    @if(($slide['text_visible'] ?? '1') && !empty($slide['text']))
                                                        <p class="text-4 text-color-light font-weight-light mb-4 appear-animation" data-appear-animation="{{ $slide['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($slide['animation_delay'] ?? '500') + 500 }}">{{ $slide['text'] }}</p>
                                                    @endif
                                                    @if(($slide['button_visible'] ?? '1') && !empty($slide['button_text']))
                                                        <a href="{{ $slide['button_link'] ?? '#' }}" class="btn {{ $slide['btn_style'] ?? 'btn-primary' }} btn-modern font-weight-bold text-2 btn-py-3 px-5 mt-2 appear-animation" data-appear-animation="{{ $slide['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($slide['animation_delay'] ?? '500') + 750 }}">{{ $slide['button_text'] }}</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <div class="owl-nav"><button type="button" role="presentation" class="owl-prev" aria-label="Previous"></button><button type="button" role="presentation" class="owl-next" aria-label="Next"></button></div>
                    </div>
                    @endif
                    @break

                {{-- 2. Features Overlap --}}
                @case('home_features_overlap')
                    @php $features = $content['features'] ?? []; @endphp
                    @if(!empty($features))
                        <div class="container" style="margin-top: -150px; position: relative; z-index: 5;">
                            <div class="row">
                                @foreach($features as $index => $feature)
                                    <div class="col-lg-4 mb-4 mb-lg-0 appear-animation" data-appear-animation="{{ $feature['animation_type'] ?? 'fadeInRightShorter' }}" data-appear-animation-delay="{{ $feature['animation_delay'] ?? (200 + ($index * 200)) }}">
                                        <div class="card bg-white border-0 box-shadow-1">
                                            <div class="card-body p-5 text-center">
                                                {{-- REMOVED data-plugin-float-element, just static icon per user request --}}
                                                <div style="display: inline-block;">
                                                    <i class="{{ $feature['icon_class'] }} text-color-primary text-10 mb-3 d-block"></i>
                                                </div>
                                                <h4 class="font-weight-bold text-5 mb-3 text-color-dark">{{ $feature['title'] }}</h4>
                                                <p class="mb-4">{{ $feature['description'] }}</p>
                                                <a href="{{ $feature['link'] ?? '#' }}" class="text-uppercase font-weight-bold text-2 text-decoration-none text-color-primary">Read More +</a>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                    @break

                {{-- 3. Simple Banner (NEW) --}}
                @case('home_banner_simple')
                    @php
                        $minHeight = $content['min_height'] ?? '400';
                        $textAlign = $content['text_align'] ?? 'text-center';
                        $paddingY = $content['padding_y'] ?? '5';
                    @endphp
                    <section class="section border-0 m-0 py-{{ $paddingY }} d-flex align-items-center" 
                             style="background-image: url({{ asset($content['image'] ?? '') }}); background-size: cover; background-position: center; position: relative; min-height: {{ $minHeight }}px;">
                         <div class="position-absolute top-0 start-0 w-100 h-100" style="background-color: #000; opacity: {{ $content['overlay_opacity'] ?? '0.5' }};"></div>
                         <div class="container position-relative z-index-1">
                            <div class="row align-items-center {{ $textAlign }}">
                                <div class="col {{ !empty($content['animation_type']) ? 'appear-animation' : '' }}" data-appear-animation="{{ $content['animation_type'] ?? '' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}">
                                    <h2 class="text-color-light font-weight-bold text-9 mb-2">{{ $content['title'] ?? '' }}</h2>
                                    <p class="text-color-light text-5 font-weight-light">{{ $content['subtitle'] ?? '' }}</p>
                                    @if(!empty($content['btn_text']))
                                        <a href="{{ $content['btn_link'] ?? '#' }}" class="btn btn-primary btn-modern font-weight-bold text-3 px-5 py-3">{{ $content['btn_text'] }}</a>
                                    @endif
                                </div>
                            </div>
                         </div>
                    </section>
                    @break

                {{-- 4. Video Block (NEW) --}}
                @case('home_video_block')
                     @php
                        $containerWidth = $content['container_width'] ?? 'container';
                        $paddingY = $content['padding_y'] ?? '5';
                        $boxShadow = !empty($content['box_shadow']) ? 'box-shadow-4' : '';
                        $borderRadius = $content['border_radius'] ?? '0';
                        $vUrl = $content['video_url'] ?? ''; 
                        $cover = $content['cover_image'] ?? '';
                     @endphp
                     <section class="section border-0 m-0 py-{{ $paddingY }}" style="background-color: transparent;">
                        <div class="{{ $containerWidth }} {{ !empty($content['animation_type']) ? 'appear-animation' : '' }}" data-appear-animation="{{ $content['animation_type'] ?? '' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}">
                            <div class="overflow-hidden {{ $boxShadow }}" style="border-radius: {{ $borderRadius }}px;">
                                @if(($content['source_type'] ?? '') == 'file')
                                    <video controls class="w-100 d-block" poster="{{ asset($cover) }}">
                                        <source src="{{ asset($vUrl) }}" type="video/mp4">
                                    </video>
                                @else
                                    <div class="ratio ratio-16x9">
                                        <iframe src="{{ $vUrl }}" allowfullscreen></iframe>
                                    </div>
                                @endif
                            </div>
                        </div>
                     </section>
                    @break

                {{-- 5. Multi Column (NEW) --}}
                @case('home_multi_column')
                    @php 
                        $layout = $content['layout'] ?? '2';
                        $colClass = $layout == '2' ? 'col-md-6' : ($layout == '3' ? 'col-md-4' : 'col-md-3');
                        $cols = $content['columns'] ?? [];
                        $gap = $content['gap'] ?? '4'; // mapped to g-* or mb-* logic
                        $alignItems = $content['align_items'] ?? 'align-items-start';
                        $rowGapClass = 'g-' . $gap;
                    @endphp
                    <div class="container-fluid py-5" style="background-color: {{ $content['bg_color'] ?? '#ffffff' }};">
                        <div class="container">
                            <div class="row {{ $rowGapClass }} {{ $alignItems }}">
                                @for($i=1; $i<=$layout; $i++)
                                    <div class="{{ $colClass }} mb-4 mb-md-0 {{ !empty($content['animation_type']) ? 'appear-animation' : '' }}" data-appear-animation="{{ $content['animation_type'] ?? '' }}" data-appear-animation-delay="{{ ($content['animation_delay'] ?? '200') + ($i * 200) }}">
                                        {!! $cols[$i]['html'] ?? '' !!}
                                    </div>
                                @endfor
                            </div>
                        </div>
                    </div>
                    @break

                {{-- 6. Services --}}
                @case('home_services_with_image')
                     @php $servicesList = \App\Models\Service::where('is_active', true)->orderBy('sort_order', 'asc')->latest()->take(5)->get(); @endphp
                     @if($servicesList->isNotEmpty())
                        <div class="container-fluid" style="background-color: {{ $content['bg_color'] ?? '#ffffff' }}; color: {{ $content['text_color'] ?? '#333333' }};">
                            <div class="container py-5 my-5">
                                <div class="row align-items-center">
                                    <div class="col-lg-6 mb-5 mb-lg-0">
                                        @if(!empty($content['image'])) <img src="{{ asset($content['image']) }}" class="img-fluid rounded box-shadow-3 appear-animation" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}"> @endif
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="overflow-hidden mb-2"><h2 class="text-color-primary font-weight-bold text-uppercase text-4 mb-0 appear-animation" data-appear-animation="{{ $content['animation_type'] ?? 'maskUp' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}">{{ $content['subtitle'] ?? 'OUR SERVICES' }}</h2></div>
                                        <h2 class="font-weight-bold text-9 mb-4 appear-animation" style="color: {{ $content['text_color'] ?? '#212529' }};" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($content['animation_delay'] ?? '200') + 200 }}">{{ $content['title'] ?? 'What We Do?' }}</h2>
                                        <p class="text-4 mb-5 appear-animation" style="color: {{ $content['text_color'] ?? '#777' }};" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($content['animation_delay'] ?? '200') + 400 }}">{{ $content['description'] ?? '' }}</p>
                                        <div class="accordion accordion-modern" id="accordionServices{{$loop->index}}">
                                            @foreach($servicesList as $idx => $svc)
                                                <div class="card card-default">
                                                    <div class="card-header"><h4 class="card-title m-0"><a class="accordion-toggle font-weight-bold {{ $idx === 0 ? '' : 'collapsed' }}" style="color: {{ $content['text_color'] ?? '#212529' }};" data-bs-toggle="collapse" data-bs-parent="#accordionServices{{$loop->parent->index}}" href="#collapseService{{ $loop->parent->index }}_{{ $idx }}">{{ $svc->title }}</a></h4></div>
                                                    <div id="collapseService{{ $loop->parent->index }}_{{ $idx }}" class="collapse {{ $idx === 0 ? 'show' : '' }}"><div class="card-body"><p>{{ $svc->short_description }}</p><a href="{{ route('services.show', $svc->slug) }}" class="text-uppercase text-1 font-weight-bold text-color-primary">Read More +</a></div></div>
                                                </div>
                                            @endforeach
                                        </div>
                                        @if(!empty($content['button_text'])) 
                                            <a href="{{ $content['button_link'] ?? '#' }}" class="btn {{ $content['btn_style'] ?? 'btn-primary' }} btn-modern font-weight-bold text-3 btn-px-5 py-3 mt-4 appear-animation" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($content['animation_delay'] ?? '200') + 600 }}">{{ $content['button_text'] }}</a> 
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                     @endif
                    @break

                {{-- 7. Portfolio Tabs --}}
                @case('home_portfolio_tabs')
                    @php $tabs = $content['tabs'] ?? []; @endphp
                    <div class="container py-4">
                        <div class="row"><div class="col"><div class="tabs tabs-bottom tabs-center tabs-simple">
                            <ul class="nav nav-tabs">
                                @foreach($tabs as $idx => $tab) <li class="nav-item"><a class="nav-link {{ $idx === 0 ? 'active' : '' }}" href="#tabsNav{{$loop->parent->index}}_{{$idx}}" data-bs-toggle="tab">{{ $tab['title'] }}</a></li> @endforeach
                            </ul>
                            <div class="tab-content">
                                @foreach($tabs as $idx => $tab)
                                    <div class="tab-pane {{ $idx === 0 ? 'active' : '' }}" id="tabsNav{{$loop->parent->index}}_{{$idx}}">
                                        <div class="text-center"><h4 class="text-color-primary font-weight-bold">{{ $tab['title'] }}</h4><div class="row align-items-center"><div class="col-lg-6"><p class="text-4">{!! $tab['content'] !!}</p></div><div class="col-lg-6">@if(!empty($tab['image'])) <img src="{{ asset($tab['image']) }}" class="img-fluid rounded"> @endif</div></div></div>
                                    </div>
                                @endforeach
                            </div>
                        </div></div></div>
                    </div>
                    @break

                {{-- 8. Logos Grid --}}
                @case('home_logos_grid')
                    @php $logos = $content['logos'] ?? []; @endphp
                    @if(!empty($logos))
                        <div class="container-fluid" style="background-color: {{ $content['bg_color'] ?? '#ffffff' }}; color: {{ $content['text_color'] ?? '#333333' }};">
                            <div class="container"><div class="row text-center pt-4 mt-5"><div class="col"><h2 class="font-weight-bold text-8 mb-2 appear-animation" style="color: {{ $content['text_color'] ?? '#333333' }};" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}">{{ $content['title'] ?? "We're proud to work with" }}</h2></div></div><div class="row text-center mt-5 pb-5 mb-5"><div class="owl-carousel owl-theme carousel-center-active-item mb-0" data-plugin-options="{'responsive': {'0': {'items': 1}, '476': {'items': 1}, '768': {'items': 5}, '992': {'items': 7}, '1200': {'items': 7}}, 'autoplay': true, 'autoplayTimeout': 3000, 'dots': false}">
                                @foreach($logos as $logo) <div><img class="img-fluid" src="{{ asset($logo) }}" alt="Partner Logo"></div> @endforeach
                            </div></div></div>
                        </div>
                    @endif
                    @break

                {{-- 9. News --}}
                @case('home_news')
                    @php $latestNews = \App\Models\NewsPost::where('status', 'published')->latest()->take(2)->get(); @endphp
                    @if($latestNews->isNotEmpty())
                        <section class="our-blog" style="background-color: {{ $content['bg_color'] ?? '#ffffff' }}; pb-5">
                            <div class="container">
                                <div class="row mt-3 pt-5"><div class="col"><p class="text-uppercase font-weight-semibold mb-1 text-color-primary appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100"><span class="line-pre-title bg-color-primary"></span>{{ $content['subtitle'] ?? 'Our Blog' }}</p><h2 class="font-weight-bold text-capitalize mb-4 custom-letter-spacing-2 custom-text-1 appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200" style="color: {{ $content['text_color'] ?? '#212529' }};">{{ $content['title'] ?? 'News and Articles' }}</h2></div></div>
                                <div class="row mb-3 pb-5"><div class="col"><div class="row">
                                    @foreach($latestNews as $post)
                                        <div class="col-lg-6 mb-4 mb-lg-0"><article><div class="card border-0 border-radius-0 box-shadow-1 appear-animation" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInUpShorter' }}" data-appear-animation-delay="{{ ($content['animation_delay'] ?? '500') + ($loop->index * 200) }}"><div class="card-body p-4 z-index-1"><a href="{{ route('news.show', $post->slug) }}"><img class="card-img-top border-radius-0" src="{{ asset($post->featured_image ?? 'img/demos/business-consulting-2/blog/blog-1.png') }}" style="height: 240px; object-fit: cover;"></a><p class="text-uppercase text-1 mb-3 pt-1 text-color-default"><time pubdate datetime="{{ $post->published_at->format('Y-m-d') }}">{{ $post->published_at->format('d M Y') }}</time><span class="opacity-3 d-inline-block px-2">|</span>0 Comments<span class="opacity-3 d-inline-block px-2">|</span>Tamio</p><div class="card-body p-0"><h4 class="card-title mb-3 text-5 font-weight-bold"><a class="text-color-secondary" href="{{ route('news.show', $post->slug) }}">{{ $post->title }}</a></h4><p class="card-text mb-3">{{ Str::limit(strip_tags($post->content), 120) }}</p><a href="{{ route('news.show', $post->slug) }}" class="font-weight-bold text-uppercase text-decoration-none d-block mt-3">Read More +</a></div></div></div></article></div>
                                    @endforeach
                                </div></div></div>
                            </div>
                        </section>
                    @endif
                    @break

                {{-- 10. Newsletter --}}
                @case('home_newsletter')
                    <section class="section section-no-border m-0" style="background-color: {{ $content['bg_color'] ?? '#F4F4F4' }}; color: {{ $content['text_color'] ?? '#333333' }};">
                        <div class="container py-5">
                            <div class="row align-items-center">
                                <div class="col-lg-6 mb-5 mb-lg-0 text-start appear-animation" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInRightShorter' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}">
                                    <h2 class="font-weight-bold text-9 mb-3" style="color: {{ $content['title_color'] ?? '#333333' }};">{{ $content['title'] ?? 'Get the Latest from Tamio Capital' }}</h2>
                                    <p class="text-4 mb-0" style="color: {{ $content['text_color'] ?? '#777777' }};">{{ $content['description'] ?? 'Subscribe to our newsletter to stay up to date on our partners, portfolio, and more.' }}</p>
                                </div>
                                <div class="col-lg-6 appear-animation" data-appear-animation="{{ $content['animation_type'] ?? 'fadeInLeftShorter' }}" data-appear-animation-delay="{{ $content['animation_delay'] ?? '200' }}">
                                    <div class="card bg-white border-0 border-radius-0 box-shadow-1">
                                        <div class="card-body p-5">
                                            <h4 class="card-title mb-4 font-weight-bold text-dark">Subscribe</h4>
                                            <form id="newsletterForm" action="{{ route('newsletter.subscribe') }}" method="POST">
                                                @csrf 
                                                <div class="form-group mb-3 text-start">
                                                    <label class="form-label text-dark font-weight-bold">Name <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="name" required placeholder="Please enter your full name">
                                                </div>
                                                <div class="form-group mb-3 text-start">
                                                    <label class="form-label text-dark font-weight-bold">Company <span class="text-danger">*</span></label>
                                                    <input type="text" class="form-control" name="company" required placeholder="Please enter your company's name">
                                                </div>
                                                <div class="form-group mb-4 text-start">
                                                    <label class="form-label text-dark font-weight-bold">Email <span class="text-danger">*</span></label>
                                                    <input type="email" class="form-control" name="email" required placeholder="Please enter a valid email address">
                                                </div>
                                                <div class="d-grid"><button class="btn btn-primary btn-modern font-weight-bold text-3 py-3" type="submit">SUBMIT</button></div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>
                    @break

            @endswitch
        @endforeach
    </div>
@endsection