@extends('layouts.app')

@section('title', $page->seo_title ?? 'Approach')
@section('meta_description', $page->seo_description ?? 'Our Approach')

@section('content')

    <div role="main" class="main">
        <section class="page-header page-header-modern custom-page-header bg-color-quaternary">
            <div class="container">
                <div class="row">
                    <div class="col-md-8 order-2 order-md-1 align-self-center p-static">
                        <h1 class="font-weight-bold text-9 text-color-secondary appear-animation"
                            data-appear-animation="fadeInRightShorter" data-appear-animation-delay="100">
                            {{ $page->title }}
                        </h1>
                    </div>
                    <div class="col-md-4 order-1 order-md-2 align-self-center">
                        <ul class="breadcrumb d-block text-md-end appear-animation"
                            data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="300">
                            <li><a href="{{ route('home') }}">Home</a></li>
                            <li class="active">{{ $page->title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </section>

        @php
            $introSection = $page->sections->firstWhere('section_identifier', 'about_intro');
            $content = $introSection ? ($introSection->content ?? []) : [];
        @endphp

        @if($introSection)
            <div class="container py-5">
                <div class="row align-items-center">
                    <div class="col">
                        @if(!empty($content['subheading']))
                            <p class="text-4 line-height-9">{{ $content['subheading'] }}</p>
                        @endif
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-6">
                        @if(!empty($content['body']))
                            {!! $content['body'] !!}
                        @endif

                        @if(!empty($content['stat_percent']))
                            <div class="d-flex align-items-center justify-content-start pt-4 appear-animation"
                                data-appear-animation="fadeIn" data-appear-animation-delay="600">
                                <div class="circular-bar custom-circular-bar m-0">
                                    <div class="circular-bar-chart" data-percent="{{ $content['stat_percent'] }}"
                                        data-plugin-options="{'barColor': '#e8465f'}">
                                        <strong class="text-5 text-color-tertiary">{{ $content['stat_percent'] }}%</strong>
                                    </div>
                                </div>
                                <h4 class="font-weight-bold text-color-tertiary m-0 ms-3">{!! $content['stat_text'] ?? '' !!}</h4>
                            </div>
                        @endif
                    </div>
                    <div class="col-lg-6 pt-4 pt-lg-0">
                        @if(!empty($content['image']))
                            <div class="card border-radius-0 box-shadow-1 border-0 mt-4 mt-lg-0 ms-lg-3 p-3 mb-3 mb-lg-0">
                                <img src="{{ asset($content['image']) }}" class="img-fluid border-radius-0" alt="Approach">
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @else
            {{-- Fallback Static HTML if Section Deleted --}}
            <div class="container py-5">
                <div class="alert alert-warning">
                    Content section "about_intro" not found. Please create it in the Admin Panel.
                </div>
            </div>
        @endif
    </div>
@endsection