@extends('layouts.admin')

@section('title', 'Team Members')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Team Members</h1>
        <a href="{{ route('admin.team.create') }}" class="btn btn-primary">Add Member</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Photo</th>
                    <th>Name</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($members as $member)
                    <tr>
                        <td>
                            @if($member->photo)
                                <img src="{{ $member->photo }}" class="rounded-circle"
                                    style="width: 40px; height: 40px; object-fit: cover;">
                            @else
                                <div class="bg-secondary rounded-circle" style="width: 40px; height: 40px;"></div>
                            @endif
                        </td>
                        <td>{{ $member->name }}</td>
                        <td>{{ $member->title }}</td>
                        <td>
                            <span
                                class="badge {{ $member->type == 'executive' ? 'bg-primary' : ($member->type == 'board' ? 'bg-info' : 'bg-secondary') }}">
                                {{ ucfirst($member->type) }}
                            </span>
                        </td>
                        <td class="text-end">
                            <a href="{{ route('admin.team.edit', $member->id) }}" class="btn btn-sm btn-primary">Edit</a>
                            <form action="{{ route('admin.team.destroy', $member->id) }}" method="POST" class="d-inline-block">
                                @csrf @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger"
                                    onclick="return confirm('Are you sure?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection