@extends('layouts.admin')

@section('title', isset($member) ? 'Edit Member' : 'Add Member')

@section('content')

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 text-primary"><i data-feather="{{ isset($member) ? 'edit' : 'user-plus' }}" class="me-2"></i>{{ isset($member) ? 'Edit Member' : 'Add Member' }}</h1>
        <a href="{{ route('admin.team.index') }}" class="btn btn-outline-secondary btn-sm"><i data-feather="arrow-left" class="me-1"></i> Back to Team</a>
    </div>

    <form action="{{ isset($member) ? route('admin.team.update', $member->id) : route('admin.team.store') }}" method="POST"
        enctype="multipart/form-data">
        @csrf
        @if(isset($member)) @method('PUT') @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-4 shadow-sm border-0">
                    <div class="card-header bg-white border-bottom-0 pb-0">
                        <h5 class="card-title mb-0 text-muted"><i data-feather="info" class="me-1 width-15 height-15"></i> Basic Info</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Full Name</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0"><i data-feather="user" class="width-15 height-15 text-muted"></i></span>
                                <input type="text" class="form-control border-start-0 ps-0" name="name" value="{{ $member->name ?? '' }}" required placeholder="e.g. John Doe">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Job Title</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0"><i data-feather="briefcase" class="width-15 height-15 text-muted"></i></span>
                                <input type="text" class="form-control border-start-0 ps-0" name="title" value="{{ $member->title ?? '' }}"
                                required placeholder="e.g. CEO">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Bio</label>
                            <textarea class="form-control" name="bio" rows="4" placeholder="Short biography...">{{ $member->bio ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-4 shadow-sm border-0">
                     <div class="card-header bg-white border-bottom-0 pb-0">
                        <h5 class="card-title mb-0 text-muted"><i data-feather="settings" class="me-1 width-15 height-15"></i> Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Member Type</label>
                             <div class="input-group">
                                <span class="input-group-text bg-light"><i data-feather="users" class="width-15 height-15 text-muted"></i></span>
                                <select class="form-select" name="type">
                                    <option value="team" {{ (isset($member) && $member->type == 'team') ? 'selected' : '' }}>Team</option>
                                    <option value="executive" {{ (isset($member) && $member->type == 'executive') ? 'selected' : '' }}>Executive Board</option>
                                    <option value="board" {{ (isset($member) && $member->type == 'board') ? 'selected' : '' }}>Board Member</option>
                                </select>
                             </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">LinkedIn URL</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0"><i data-feather="linkedin" class="width-15 height-15 text-muted"></i></span>
                                <input type="url" class="form-control border-start-0 ps-0" name="linkedin_url"
                                    value="{{ $member->linkedin_url ?? '' }}" placeholder="https://linkedin.com/in/...">
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Sort Order</label>
                            <input type="number" class="form-control" name="sort_order"
                                value="{{ $member->sort_order ?? 0 }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Photo</label>
                            <div class="input-group mb-2">
                                <input type="text" name="photo" id="photo" class="form-control" value="{{ $member->photo ?? '' }}" placeholder="Select path or upload new" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#mediaLibraryModal" data-input-target="#photo" data-preview-target="#photo_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="photo_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="photo_preview" class="mt-2">
                                @if(isset($member->photo))
                                    <img src="{{ asset($member->photo) }}" class="mt-2 rounded shadow-sm" style="max-height: 100px;">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Member</button>
                </div>
            </div>
        </div>
    </form>
    @include('admin.media.modal')
@endsection