@extends('layouts.admin')

@section('title', isset($member) ? 'Edit Member' : 'Add Member')

@section('content')
    <h1 class="h3 mb-3">{{ isset($member) ? 'Edit Member' : 'Add Member' }}</h1>

    <form action="{{ isset($member) ? route('admin.team.update', $member->id) : route('admin.team.store') }}" method="POST"
        enctype="multipart/form-data">
        @csrf
        @if(isset($member)) @method('PUT') @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Full Name</label>
                            <input type="text" class="form-control" name="name" value="{{ $member->name ?? '' }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Job Title</label>
                            <input type="text" class="form-control" name="title" value="{{ $member->title ?? '' }}"
                                required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Bio</label>
                            <textarea class="form-control" name="bio" rows="4">{{ $member->bio ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Member Type</label>
                            <select class="form-select" name="type">
                                <option value="team" {{ (isset($member) && $member->type == 'team') ? 'selected' : '' }}>Team
                                </option>
                                <option value="executive" {{ (isset($member) && $member->type == 'executive') ? 'selected' : '' }}>Executive Board</option>
                                <option value="board" {{ (isset($member) && $member->type == 'board') ? 'selected' : '' }}>
                                    Board Member</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">LinkedIn URL</label>
                            <input type="url" class="form-control" name="linkedin_url"
                                value="{{ $member->linkedin_url ?? '' }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" class="form-control" name="sort_order"
                                value="{{ $member->sort_order ?? 0 }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Photo</label>
                            <div class="input-group mb-2">
                                <input type="text" name="photo" id="photo" class="form-control"
                                    value="{{ $member->photo ?? '' }}" placeholder="Select path or upload new" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#photo"
                                    data-preview-target="#photo_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="photo_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="photo_preview" class="mt-2">
                                @if(isset($member->photo))
                                    <img src="{{ asset($member->photo) }}" class="mt-2" style="max-height: 100px;">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Member</button>
                </div>
            </div>
        </div>
    </form>
    @include('admin.media.modal')
@endsection