@extends('layouts.admin')

@section('title', 'Global Settings')

@section('content')
    <h1 class="h3 mb-3">Global Settings</h1>

    <div class="row">
        <div class="col-md-3 col-xl-2">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Profile Settings</h5>
                </div>
                <div class="list-group list-group-flush" role="tablist">
                    <a class="list-group-item list-group-item-action active" data-bs-toggle="list" href="#general"
                        role="tab">General</a>
                    <a class="list-group-item list-group-item-action" data-bs-toggle="list" href="#contact"
                        role="tab">Contact Info</a>
                    <a class="list-group-item list-group-item-action" data-bs-toggle="list" href="#social" role="tab">Social
                        Media</a>
                    <a class="list-group-item list-group-item-action" data-bs-toggle="list" href="#appearance" role="tab"><i
                            data-feather="monitor" class="width-15 height-15 me-1"></i> Appearance</a>
                </div>
            </div>
        </div>

        <div class="col-md-9 col-xl-10">
            <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="general" role="tabpanel">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">General Info</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">Site Name</label>
                                    <input type="text" class="form-control" name="site_name"
                                        value="{{ $settings['site_name'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Footer Text</label>
                                    <input type="text" class="form-control" name="footer_text"
                                        value="{{ $settings['footer_text'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Site Logo</label>
                                    <div class="input-group mb-2">
                                        <input type="text" name="site_logo" id="site_logo" class="form-control"
                                            value="{{ $settings['site_logo'] ?? '' }}"
                                            placeholder="Select path or upload new" readonly>
                                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                            data-bs-target="#mediaLibraryModal" data-input-target="#site_logo"
                                            data-preview-target="#site_logo_preview">Select from Library</button>
                                    </div>
                                    <input type="file" class="form-control" name="site_logo_file">
                                    <div class="form-text">Upload a new file to replace the current one.</div>
                                    <div id="site_logo_preview" class="mt-2">
                                        @if(isset($settings['site_logo']))
                                            <img src="{{ asset($settings['site_logo']) }}" alt="Current Logo"
                                                style="max-height: 50px;">
                                        @endif
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Favicon</label>
                                    <div class="input-group mb-2">
                                        <input type="text" name="site_favicon" id="site_favicon" class="form-control"
                                            value="{{ $settings['site_favicon'] ?? '' }}"
                                            placeholder="Select path or upload new" readonly>
                                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                            data-bs-target="#mediaLibraryModal" data-input-target="#site_favicon"
                                            data-preview-target="#site_favicon_preview">Select from Library</button>
                                    </div>
                                    <input type="file" class="form-control" name="site_favicon_file">
                                    <div class="form-text">Upload a new file to replace the current one.</div>
                                    <div id="site_favicon_preview" class="mt-2">
                                        @if(isset($settings['site_favicon']))
                                            <img src="{{ asset($settings['site_favicon']) }}" alt="Current Favicon"
                                                style="max-height: 32px;" class="border p-1">
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="contact" role="tabpanel">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Contact Information</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">Email Address</label>
                                    <input type="email" class="form-control" name="contact_email"
                                        value="{{ $settings['contact_email'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Phone Number</label>
                                    <input type="text" class="form-control" name="contact_phone"
                                        value="{{ $settings['contact_phone'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Address</label>
                                    <textarea class="form-control" name="contact_address"
                                        rows="2">{{ $settings['contact_address'] ?? '' }}</textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Working Hours</label>
                                    <input type="text" class="form-control" name="contact_hours"
                                        value="{{ $settings['contact_hours'] ?? 'Mon - Sat 9.00am - 6.00pm / Sunday - CLOSED' }}"
                                        placeholder="e.g. Mon - Sat 9.00am - 6.00pm">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Google Map URL (Embed)</label>
                                    <textarea class="form-control" name="contact_map_url" rows="3"
                                        placeholder="Paste the 'src' attribute from the Google Maps Embed code (starts with https://www.google.com/maps/embed...)">{{ $settings['contact_map_url'] ?? '' }}</textarea>
                                    <div class="form-text">Paste only the URL from the iframe src attribute.</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="social" role="tabpanel">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">Social Media Links</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">LinkedIn URL</label>
                                    <input type="url" class="form-control" name="social_linkedin"
                                        value="{{ $settings['social_linkedin'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Twitter/X URL</label>
                                    <input type="url" class="form-control" name="social_twitter"
                                        value="{{ $settings['social_twitter'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Facebook URL</label>
                                    <input type="url" class="form-control" name="social_facebook"
                                        value="{{ $settings['social_facebook'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Instagram URL</label>
                                    <input type="url" class="form-control" name="social_instagram"
                                        value="{{ $settings['social_instagram'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">YouTube URL</label>
                                    <input type="url" class="form-control" name="social_youtube"
                                        value="{{ $settings['social_youtube'] ?? '' }}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="appearance" role="tabpanel">
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i data-feather="droplet" class="width-15 height-15 me-1"></i>
                                    Brand Colors</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Primary Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color" name="primary_color"
                                                value="{{ $settings['primary_color'] ?? '#0088cc' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['primary_color'] ?? '#0088cc' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Secondary Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="secondary_color"
                                                value="{{ $settings['secondary_color'] ?? '#e36159' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['secondary_color'] ?? '#e36159' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Tertiary Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="tertiary_color" value="{{ $settings['tertiary_color'] ?? '#2baab1' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['tertiary_color'] ?? '#2baab1' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Quaternary Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="quaternary_color"
                                                value="{{ $settings['quaternary_color'] ?? '#383f48' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['quaternary_color'] ?? '#383f48' }}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i data-feather="layout" class="width-15 height-15 me-1"></i>
                                    Header Styling</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Font Size (px)</label>
                                        <input type="number" class="form-control" name="header_font_size"
                                            value="{{ $settings['header_font_size'] ?? '12' }}">
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Font Weight</label>
                                        <select class="form-select" name="header_font_weight">
                                            <option value="400" {{ ($settings['header_font_weight'] ?? '') == '400' ? 'selected' : '' }}>Normal (400)</option>
                                            <option value="600" {{ ($settings['header_font_weight'] ?? '') == '600' ? 'selected' : '' }}>Semi Bold (600)</option>
                                            <option value="700" {{ ($settings['header_font_weight'] ?? '') == '700' ? 'selected' : '' }}>Bold (700)</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label class="form-label">Text Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="header_text_color"
                                                value="{{ $settings['header_text_color'] ?? '#E36159' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['header_text_color'] ?? '#E36159' }}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i data-feather="layout" class="width-15 height-15 me-1"></i>
                                    Footer Styling</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Background Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="footer_bg_color"
                                                value="{{ $settings['footer_bg_color'] ?? '#F4F4F4' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['footer_bg_color'] ?? '#F4F4F4' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Text Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="footer_text_color"
                                                value="{{ $settings['footer_text_color'] ?? '#333333' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['footer_text_color'] ?? '#333333' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Title Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="footer_title_color"
                                                value="{{ $settings['footer_title_color'] ?? '#111111' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['footer_title_color'] ?? '#111111' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Link Color (Hover is usually Primary)</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="footer_link_color"
                                                value="{{ $settings['footer_link_color'] ?? '#E36159' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['footer_link_color'] ?? '#E36159' }}" readonly>
                                        </div>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Footer Font Family</label>
                                        <select class="form-select" name="footer_font_family">
                                            <option value="" {{ ($settings['footer_font_family'] ?? '') == '' ? 'selected' : '' }}>Inherit from Body</option>
                                            <option value="'Inter', sans-serif" {{ ($settings['footer_font_family'] ?? '') == "'Inter', sans-serif" ? 'selected' : '' }}>Inter</option>
                                            <option value="'Roboto', sans-serif" {{ ($settings['footer_font_family'] ?? '') == "'Roboto', sans-serif" ? 'selected' : '' }}>Roboto</option>
                                            <option value="'Open Sans', sans-serif" {{ ($settings['footer_font_family'] ?? '') == "'Open Sans', sans-serif" ? 'selected' : '' }}>Open Sans</option>
                                            <option value="'Lato', sans-serif" {{ ($settings['footer_font_family'] ?? '') == "'Lato', sans-serif" ? 'selected' : '' }}>Lato</option>
                                            <option value="'Poppins', sans-serif" {{ ($settings['footer_font_family'] ?? '') == "'Poppins', sans-serif" ? 'selected' : '' }}>Poppins</option>
                                            <option value="'Playfair Display', serif" {{ ($settings['footer_font_family'] ?? '') == "'Playfair Display', serif" ? 'selected' : '' }}>Playfair Display
                                                (Serif)</option>
                                            <option value="'Times New Roman', serif" {{ ($settings['footer_font_family'] ?? '') == "'Times New Roman', serif" ? 'selected' : '' }}>Times New Roman (Serif)
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Footer Font Size (px)</label>
                                        <input type="number" class="form-control" name="footer_font_size"
                                            value="{{ $settings['footer_font_size'] ?? '14' }}" placeholder="14">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class="form-label">Copyright Background Color</label>
                                        <div class="input-group">
                                            <input type="color" class="form-control form-control-color"
                                                name="copyright_bg_color"
                                                value="{{ $settings['copyright_bg_color'] ?? '#111111' }}"
                                                title="Choose your color">
                                            <input type="text" class="form-control"
                                                value="{{ $settings['copyright_bg_color'] ?? '#111111' }}" readonly>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0"><i data-feather="type" class="width-15 height-15 me-1"></i>
                                    Typography</h5>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">Font Family</label>
                                    <select class="form-select" name="font_family">
                                        <option value="Inter" {{ ($settings['font_family'] ?? '') == 'Inter' ? 'selected' : '' }}>Inter</option>
                                        <option value="Roboto" {{ ($settings['font_family'] ?? '') == 'Roboto' ? 'selected' : '' }}>Roboto</option>
                                        <option value="Open Sans" {{ ($settings['font_family'] ?? '') == 'Open Sans' ? 'selected' : '' }}>Open Sans</option>
                                        <option value="Lato" {{ ($settings['font_family'] ?? '') == 'Lato' ? 'selected' : '' }}>Lato</option>
                                        <option value="Montserrat" {{ ($settings['font_family'] ?? '') == 'Montserrat' ? 'selected' : '' }}>Montserrat</option>
                                        <option value="Poppins" {{ ($settings['font_family'] ?? '') == 'Poppins' ? 'selected' : '' }}>Poppins</option>
                                        <option value="Playfair Display" {{ ($settings['font_family'] ?? '') == 'Playfair Display' ? 'selected' : '' }}>Playfair Display</option>
                                        <option value="Plus Jakarta Sans" {{ ($settings['font_family'] ?? '') == 'Plus Jakarta Sans' ? 'selected' : '' }}>Plus Jakarta Sans</option>
                                        <option value="Outfit" {{ ($settings['font_family'] ?? '') == 'Outfit' ? 'selected' : '' }}>Outfit</option>
                                        <option value="Manrope" {{ ($settings['font_family'] ?? '') == 'Manrope' ? 'selected' : '' }}>Manrope</option>
                                        <option value="DM Sans" {{ ($settings['font_family'] ?? '') == 'DM Sans' ? 'selected' : '' }}>DM Sans</option>
                                        <option value="Times New Roman" {{ ($settings['font_family'] ?? '') == 'Times New Roman' ? 'selected' : '' }}>Times New Roman</option>
                                    </select>
                                    <div class="form-text">Selected font will be applied to the headings and body text.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-end mb-3">
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
    </div>
    @include('admin.media.modal')
@endsection