@extends('layouts.admin')

@section('content')
    <div class="row mb-4">
        <div class="col-12">
            <h1 class="h3 text-gray-800">New Service</h1>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <form action="{{ route('admin.services.store') }}" method="POST">
                @csrf

                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" name="title" class="form-control" value="{{ old('title') }}" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Short Description (for Homepage/Lists)</label>
                            <textarea name="short_description" class="form-control" rows="3" maxlength="500"
                                required>{{ old('short_description') }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Full Content</label>
                            <textarea name="content" class="form-control rich-text-editor">{{ old('content') }}</textarea>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="is_active" class="form-select">
                                <option value="1" {{ old('is_active', '1') == '1' ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ old('is_active') == '0' ? 'selected' : '' }}>Draft</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" name="sort_order" class="form-control" value="{{ old('sort_order', 0) }}">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <div class="input-group">
                                <input type="text" class="form-control" name="image" id="image_input"
                                    value="{{ old('image') }}" readonly>
                                <button class="btn btn-outline-secondary" type="button" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-id="image_input">
                                    Select
                                </button>
                            </div>
                            <div class="mt-2">
                                <img id="image_input_preview" src="{{ old('image') ? asset(old('image')) : '' }}"
                                    style="max-width: 100%; {{ old('image') ? '' : 'display:none;' }}"
                                    class="img-thumbnail">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-end">
                    <a href="{{ route('admin.services.index') }}" class="btn btn-secondary me-2">Cancel</a>
                    <button type="submit" class="btn btn-primary">Create Service</button>
                </div>
            </form>
        </div>
    </div>

    @include('admin.media.modal')
@endsection

@push('scripts')
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function () {
            $('.rich-text-editor').summernote({
                height: 400,
                callbacks: {
                    onImageUpload: function (files) {
                        // Create formData
                        var data = new FormData();
                        data.append("file", files[0]);

                        // Upload via standard media upload endpoint if needed, or implement generic handler.
                        // For now, simpler to use Media Library for main images.
                        // But if inline image needed, standard summernote base64 is default or we can setup a route.
                        // Keeping default base64 for content images for simplicity unless requested otherwise.
                    }
                }
            });
        });
    </script>
@endpush