@extends('layouts.admin')

@section('title', isset($category) ? 'Edit Category' : 'Create Category')

@section('content')
    <h1 class="h3 mb-3">{{ isset($category) ? 'Edit Category' : 'Create Category' }}</h1>

    <div class="card">
        <div class="card-body">
            <form
                action="{{ isset($category) ? route('admin.portfolio_categories.update', $category->id) : route('admin.portfolio_categories.store') }}"
                method="POST">
                @csrf
                @if(isset($category)) @method('PUT') @endif

                <div class="mb-3">
                    <label class="form-label">Name</label>
                    <input type="text" class="form-control" name="name" value="{{ $category->name ?? '' }}" required>
                </div>

                <button type="submit" class="btn btn-primary">Save Category</button>
                <a href="{{ route('admin.portfolio_categories.index') }}" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
@endsection