@extends('layouts.admin')

@section('title', 'Portfolio Companies')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Portfolio Companies</h1>
        <div>
            <a href="{{ route('admin.portfolio-categories.index') }}" class="btn btn-outline-secondary me-2">Manage
                Categories</a>
            <a href="{{ route('admin.portfolio.create') }}" class="btn btn-primary">Add New Company</a>
        </div>
    </div>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover my-0">
                <thead>
                    <tr>
                        <th>Logo</th>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Sector</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($companies as $company)
                        <tr>
                            <td>
                                @if($company->logo)
                                    <img src="{{ $company->logo }}" style="width: 40px; height: 40px; object-fit: contain;">
                                @endif
                            </td>
                            <td>{{ $company->name }}</td>
                            <td>{{ $company->category_name }}</td>
                            <td>{{ $company->sector }}</td>
                            <td class="text-end">
                                <a href="{{ route('admin.portfolio.edit', $company->id) }}"
                                    class="btn btn-sm btn-primary">Edit</a>
                                <form action="{{ route('admin.portfolio.destroy', $company->id) }}" method="POST"
                                    class="d-inline-block">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger"
                                        onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection