@extends('layouts.admin')

@section('title', isset($company) ? 'Edit Company' : 'Create Company')

@section('content')
    <h1 class="h3 mb-3">{{ isset($company) ? 'Edit Company' : 'Create Company' }}</h1>

    <form action="{{ isset($company) ? route('admin.portfolio.update', $company->id) : route('admin.portfolio.store') }}"
        method="POST" enctype="multipart/form-data">
        @csrf
        @if(isset($company)) @method('PUT') @endif

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Company Info</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Company Name</label>
                            <input type="text" class="form-control" name="name" value="{{ $company->name ?? '' }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description"
                                rows="4">{{ $company->description ?? '' }}</textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Services (One per line)</label>
                            <textarea class="form-control" name="services"
                                rows="4">{{ $company->services ?? '' }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Classification</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Category</label>
                            <select class="form-select" name="portfolio_category_id" required>
                                <option value="">Select Category</option>
                                @foreach($categories as $cat)
                                    <option value="{{ $cat->id }}" {{ (isset($company) && $company->portfolio_category_id == $cat->id) ? 'selected' : '' }}>
                                        {{ $cat->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sector Label</label>
                            <input type="text" class="form-control" name="sector" value="{{ $company->sector ?? '' }}"
                                placeholder="e.g. Technology">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Sort Order</label>
                            <input type="number" class="form-control" name="sort_order"
                                value="{{ $company->sort_order ?? 0 }}">
                        </div>
                    </div>
                </div>

                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Media</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Logo</label>
                            <div class="input-group mb-2">
                                <input type="text" name="logo" id="logo" class="form-control"
                                    value="{{ $company->logo ?? '' }}" placeholder="Select path or upload new" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#logo"
                                    data-preview-target="#logo_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="logo_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="logo_preview" class="mt-2 text-center bg-light p-2 rounded">
                                @if(isset($company->logo))
                                    <img src="{{ asset($company->logo) }}" class="img-fluid" style="max-height: 50px">
                                @endif
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Featured Image</label>
                            <div class="input-group mb-2">
                                <input type="text" name="featured_image" id="featured_image" class="form-control"
                                    value="{{ $company->featured_image ?? '' }}" placeholder="Select path or upload new"
                                    readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#featured_image"
                                    data-preview-target="#featured_image_preview">Select from Library</button>
                            </div>
                            <input type="file" class="form-control" name="featured_image_file">
                            <div class="form-text">Upload a new file to replace the current one.</div>
                            <div id="featured_image_preview" class="mt-2">
                                @if(isset($company->featured_image))
                                    <img src="{{ asset($company->featured_image) }}" class="mt-2 img-fluid"
                                        style="max-height: 100px;">
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary">Save Company</button>
                </div>
            </div>
        </div>
    </form>
    @include('admin.media.modal')
@endsection