@extends('layouts.admin')

@section('title', 'Manage Sections: ' . $page->title)

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h1 class="h3">Sections: {{ $page->title }}</h1>
            <a href="{{ route('admin.pages.edit', $page->id) }}" class="btn btn-outline-secondary btn-sm">Back to Page
                Settings</a>
        </div>
        <a href="{{ route('admin.pages.sections.create', $page->id) }}" class="btn btn-primary">Add New Section</a>
    </div>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover my-0">
                <thead>
                    <tr>
                        <th style="width: 50px;"></th>
                        <th>Identifier</th>
                        <th>Status</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody id="sections-list" data-page-id="{{ $page->id }}">
                    @foreach($sections as $section)
                        <tr data-id="{{ $section->id }}">
                            <td class="align-middle text-center cursor-move handle">
                                <i data-feather="move"></i>
                            </td>
                            <td class="align-middle">
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                        @if($section->section_identifier === 'home_slider')
                                            <i data-feather="monitor" class="text-muted"></i>
                                        @elseif($section->section_identifier === 'home_features_overlap')
                                            <i data-feather="layers" class="text-muted"></i>
                                        @elseif($section->section_identifier === 'home_services_with_image')
                                            <i data-feather="list" class="text-muted"></i>
                                        @elseif($section->section_identifier === 'home_portfolio_tabs')
                                            <i data-feather="grid" class="text-muted"></i>
                                        @elseif($section->section_identifier === 'home_logos_grid')
                                            <i data-feather="briefcase" class="text-muted"></i>
                                        @elseif(Str::contains($section->section_identifier, 'news'))
                                            <i data-feather="file-text" class="text-muted"></i>
                                        @elseif(Str::contains($section->section_identifier, 'stats') || Str::contains($section->section_identifier, 'counter'))
                                            <i data-feather="bar-chart-2" class="text-muted"></i>
                                        @elseif(Str::contains($section->section_identifier, 'contact'))
                                            <i data-feather="phone" class="text-muted"></i>
                                        @else
                                            <i data-feather="layout" class="text-muted"></i>
                                        @endif
                                    </div>
                                    <div>
                                        <strong class="d-block text-dark">{{ Str::headline($section->section_identifier) }}</strong>
                                        {{-- Slug hidden as per request --}}
                                    </div>
                                </div>
                            </td>
                            <td class="align-middle">
                                <div class="form-check form-switch">
                                    <input class="form-check-input status-toggle" type="checkbox" 
                                        data-section-id="{{ $section->id }}"
                                        {{ $section->is_active ? 'checked' : '' }}>
                                </div>
                            </td>
                            <td class="text-end align-middle">
                                <a href="{{ route('admin.pages.sections.edit', [$page->id, $section->id]) }}"
                                    class="btn btn-sm btn-primary">Edit Content</a>
                                <form action="{{ route('admin.pages.sections.destroy', [$page->id, $section->id]) }}" method="POST"
                                    class="d-inline-block">
                                    @csrf @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger"
                                        onclick="return confirm('Are you sure?')">Delete</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // SortableJS
            var el = document.getElementById('sections-list');
            var sortable = Sortable.create(el, {
                handle: '.handle',
                animation: 150,
                onEnd: function(evt) {
                    var pageId = el.getAttribute('data-page-id');
                    var sections = [];
                    
                    document.querySelectorAll('#sections-list tr').forEach(function(row, index) {
                        sections.push({
                            id: row.getAttribute('data-id'),
                            order: index + 1
                        });
                    });

                    // AJAX call to reorder
                    fetch(`/admin/pages/${pageId}/sections/reorder`, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        body: JSON.stringify({ sections: sections })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if(data.status === 'success') {
                            showToast('Order updated successfully');
                        } else {
                            showToast('Failed to update order.', 'danger');
                        }
                    })
                    .catch(error => {
                        showToast('An error occurred.', 'danger');
                    });
                }
            });

            // Status Toggle
            document.querySelectorAll('.status-toggle').forEach(function(toggle) {
                toggle.addEventListener('change', function() {
                    var sectionId = this.getAttribute('data-section-id');
                    var pageId = '{{ $page->id }}';
                    
                    fetch(`/admin/pages/${pageId}/sections/${sectionId}/toggle-status`, {
                        method: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if(data.status === 'success') {
                            showToast('Status updated successfully');
                        } else {
                            this.checked = !this.checked; // Revert
                            showToast('Failed to update status.', 'danger');
                        }
                    })
                    .catch(error => {
                        this.checked = !this.checked; // Revert
                        showToast('An error occurred.', 'danger');
                    });
                });
            });
        });
    </script>
@endsection