@extends('layouts.admin')

@section('title', 'Edit Section: ' . Str::headline($section->section_identifier))

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h1 class="h3">Edit Section: {{ Str::headline($section->section_identifier) }}</h1>
            <a href="{{ route('admin.pages.sections.index', $page->id) }}" class="btn btn-outline-secondary btn-sm">Back to
                Sections</a>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <form action="{{ route('admin.pages.sections.update_post', [$page->id, $section->id]) }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                {{-- No PUT method here to avoid issues with large file uploads --}}

                <div class="row mb-4">
                    <div class="col-md-6">
                        <label class="form-label text-muted small text-uppercase fw-bold"><i data-feather="eye"
                                class="width-15 height-15 me-1"></i> Visibility</label>
                        <div class="form-check form-switch p-3 bg-light rounded border">
                            <input class="form-check-input ms-0 me-2" type="checkbox" id="is_active" name="is_active"
                                value="1" {{ $section->is_active ? 'checked' : '' }}>
                            <label class="form-check-label fw-bold" for="is_active">Visible on Website</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label for="order" class="form-label text-muted small text-uppercase fw-bold"><i data-feather="list"
                                class="width-15 height-15 me-1"></i> Sort Order</label>
                        <input type="number" class="form-control" id="order" name="order"
                            value="{{ old('order', $section->order) }}">
                    </div>
                </div>

                <hr class="my-4">
                <h4 class="mb-4 d-flex align-items-center text-primary">
                    <i data-feather="layout" class="me-2"></i> Content Settings
                </h4>

                {{-- Dynamic Fields based on Identifier --}}
                @if($section->section_identifier === 'home_features_overlap')
                    <div class="alert alert-info">
                        <i data-feather="info" class="me-2"></i> Manage the 3 feature blocks that overlap the hero section.
                    </div>

                    <div id="features-container">
                        @php
                            $features = $section->content['features'] ?? [];
                            // Ensure at least 3 items for structure, or defaults
                            if (empty($features)) {
                                $features = [
                                    ['title' => 'Strategic Planning', 'icon_class' => 'fas fa-chart-line'],
                                    ['title' => 'Financial Clean-Up', 'icon_class' => 'fas fa-balance-scale'],
                                    ['title' => 'Cash Flow Planning', 'icon_class' => 'fas fa-chart-bar'],
                                ];
                            }
                        @endphp

                        @foreach($features as $index => $feature)
                            <div class="card mb-3 feature-item shadow-sm border" data-index="{{ $index }}">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0 text-dark"><i class="{{ $feature['icon_class'] ?? 'fas fa-star' }} me-2"></i>
                                        Feature #{{ $loop->iteration }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Title</label>
                                            <input type="text" name="content[features][{{ $index }}][title]" class="form-control"
                                                value="{{ $feature['title'] ?? '' }}">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">Icon Class (FontAwesome)</label>
                                            <input type="text" name="content[features][{{ $index }}][icon_class]"
                                                class="form-control" value="{{ $feature['icon_class'] ?? '' }}"
                                                placeholder="e.g. fas fa-chart-line">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Description</label>
                                            <textarea name="content[features][{{ $index }}][description]" class="form-control"
                                                rows="2">{{ $feature['description'] ?? '' }}</textarea>
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Link (Optional)</label>
                                            <input type="text" name="content[features][{{ $index }}][link]" class="form-control"
                                                value="{{ $feature['link'] ?? '' }}" placeholder="#">
                                        </div>
                                        <div class="col-md-12 mb-3">
                                            <label class="form-label">Entry Animation</label>
                                            <div class="input-group">
                                                <select name="content[features][{{ $index }}][animation_type]" class="form-select">
                                                    <option value="" {{ ($feature['animation_type'] ?? '') == '' ? 'selected' : '' }}>
                                                        None</option>
                                                    <option value="fadeIn" {{ ($feature['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                                    <option value="fadeInUpShorter" {{ ($feature['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                                    <option value="fadeInLeftShorter" {{ ($feature['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                                    <option value="fadeInRightShorter" {{ ($feature['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter
                                                    </option>
                                                </select>
                                                <input type="number" name="content[features][{{ $index }}][animation_delay]"
                                                    class="form-control" placeholder="Delay ms"
                                                    value="{{ $feature['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @endif

                @if($section->section_identifier === 'home_slider')
                    {{-- Home Slider Specific Fields --}}
                    <div class="alert alert-info">
                        <i data-feather="info" class="me-2"></i> Manage your homepage hero slider. Add images or videos, control
                        overlays, and style your content.
                    </div>

                    <div id="slides-container">
                        @php
                            $slides = $section->content['slides'] ?? [];
                            if (empty($slides)) {
                                $slides = [['title' => 'Welcome', 'bg_type' => 'image']];
                            }
                        @endphp

                        @foreach($slides as $index => $slide)
                            <div class="card mb-4 slide-item shadow-sm border" data-index="{{ $index }}">
                                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0 text-dark"><i data-feather="monitor" class="me-2"></i> Slide #<span
                                            class="slide-number">{{ $loop->iteration }}</span></h5>
                                    <button type="button" class="btn btn-danger btn-sm remove-slide" title="Remove Slide"><i
                                            data-feather="trash-2"></i></button>
                                </div>
                                <div class="card-body">
                                    <ul class="nav nav-tabs nav-justified mb-3" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-bs-toggle="tab" href="#slide-content-{{ $index }}"
                                                role="tab">Content</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#slide-media-{{ $index }}"
                                                role="tab">Background & Overlay</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#slide-style-{{ $index }}"
                                                role="tab">Style & Layout</a>
                                        </li>
                                    </ul>
                                    <div class="tab-content">
                                        {{-- Content Tab --}}
                                        <div class="tab-pane fade show active" id="slide-content-{{ $index }}" role="tabpanel">
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <div class="mb-3">
                                                        <label class="form-label">Title</label>
                                                        <div class="input-group">
                                                            <div class="input-group-text">
                                                                <input class="form-check-input mt-0" type="checkbox"
                                                                    name="content[slides][{{ $index }}][title_visible]" value="1" {{ ($slide['title_visible'] ?? '1') ? 'checked' : '' }}
                                                                    title="Show/Hide">
                                                            </div>
                                                            <input type="text" name="content[slides][{{ $index }}][title]"
                                                                class="form-control" value="{{ $slide['title'] ?? '' }}"
                                                                placeholder="Enter slide title">
                                                        </div>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Subtitle</label>
                                                        <div class="input-group">
                                                            <div class="input-group-text">
                                                                <input class="form-check-input mt-0" type="checkbox"
                                                                    name="content[slides][{{ $index }}][subtitle_visible]" value="1"
                                                                    {{ ($slide['subtitle_visible'] ?? '1') ? 'checked' : '' }}
                                                                    title="Show/Hide">
                                                            </div>
                                                            <input type="text" name="content[slides][{{ $index }}][subtitle]"
                                                                class="form-control" value="{{ $slide['subtitle'] ?? '' }}"
                                                                placeholder="Enter slide subtitle">
                                                        </div>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Description / Text</label>
                                                        <div class="input-group">
                                                            <div class="input-group-text">
                                                                <input class="form-check-input mt-0" type="checkbox"
                                                                    name="content[slides][{{ $index }}][text_visible]" value="1" {{ ($slide['text_visible'] ?? '1') ? 'checked' : '' }}
                                                                    title="Show/Hide">
                                                            </div>
                                                            <textarea name="content[slides][{{ $index }}][text]"
                                                                class="form-control" rows="2"
                                                                placeholder="Enter additional text (optional)">{{ $slide['text'] ?? '' }}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="mb-3">
                                                        <label class="form-label">Button Text</label>
                                                        <div class="input-group">
                                                            <div class="input-group-text">
                                                                <input class="form-check-input mt-0" type="checkbox"
                                                                    name="content[slides][{{ $index }}][button_visible]" value="1"
                                                                    {{ ($slide['button_visible'] ?? '1') ? 'checked' : '' }}
                                                                    title="Show/Hide">
                                                            </div>
                                                            <input type="text" name="content[slides][{{ $index }}][button_text]"
                                                                class="form-control" value="{{ $slide['button_text'] ?? '' }}"
                                                                placeholder="e.g. Learn More">
                                                        </div>
                                                    </div>
                                                    <div class="mb-3">
                                                        <label class="form-label">Button Link</label>
                                                        <input type="text" name="content[slides][{{ $index }}][button_link]"
                                                            class="form-control" value="{{ $slide['button_link'] ?? '' }}"
                                                            placeholder="e.g. /about">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Media Tab --}}
                                        <div class="tab-pane fade" id="slide-media-{{ $index }}" role="tabpanel">
                                            <div class="mb-3">
                                                <label class="form-label">Background Type</label>
                                                <select name="content[slides][{{ $index }}][bg_type]"
                                                    class="form-select bg-type-selector">
                                                    <option value="image" {{ ($slide['bg_type'] ?? 'image') == 'image' ? 'selected' : '' }}>Image</option>
                                                    <option value="video" {{ ($slide['bg_type'] ?? '') == 'video' ? 'selected' : '' }}>Video (MP4/WebM)</option>
                                                    <option value="color" {{ ($slide['bg_type'] ?? '') == 'color' ? 'selected' : '' }}>Solid Color</option>
                                                </select>
                                            </div>

                                            <div class="mb-3 bg-field bg-image"
                                                style="{{ ($slide['bg_type'] ?? 'image') == 'image' ? '' : 'display:none;' }}">
                                                <label class="form-label">Image</label>
                                                <div class="input-group mb-2">
                                                    <input type="text" name="content[slides][{{ $index }}][image]"
                                                        id="slide-image-{{ $index }}" class="form-control"
                                                        value="{{ $slide['image'] ?? '' }}" placeholder="Select image or upload new"
                                                        readonly>
                                                    <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                                        data-bs-target="#mediaLibraryModal"
                                                        data-input-target="#slide-image-{{ $index }}"
                                                        data-preview-target="#slide-image-preview-{{ $index }}">Select from
                                                        Library</button>
                                                </div>
                                                <input type="file" name="content[slides][{{ $index }}][image_file]"
                                                    class="form-control">
                                                <div class="form-text">Upload a new file to replace the current one.</div>
                                                <div id="slide-image-preview-{{ $index }}" class="mt-2">
                                                    @if(isset($slide['image']) && $slide['image'])
                                                        <img src="{{ asset($slide['image']) }}" alt="Preview" class="rounded shadow-sm"
                                                            style="height: 100px;">
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="mb-3 bg-field bg-video"
                                                style="{{ ($slide['bg_type'] ?? '') == 'video' ? '' : 'display:none;' }}">
                                                <label class="form-label">Video Source</label>
                                                <select class="form-select mb-2 video-source-selector"
                                                    name="content[slides][{{ $index }}][video_source]"
                                                    onchange="toggleVideoSource(this)">
                                                    <option value="url" {{ ($slide['video_source'] ?? 'url') == 'url' ? 'selected' : '' }}>External URL</option>
                                                    <option value="file" {{ ($slide['video_source'] ?? '') == 'file' ? 'selected' : '' }}>Self-Hosted (Upload)</option>
                                                </select>

                                                <div class="video-url-group"
                                                    style="{{ ($slide['video_source'] ?? 'url') == 'url' ? 'display:block;' : 'display:none;' }}">
                                                    <label class="form-label">Video URL (MP4/WebM)</label>
                                                    <input type="text" class="form-control"
                                                        name="content[slides][{{ $index }}][video_url]"
                                                        value="{{ $slide['video_url'] ?? '' }}"
                                                        placeholder="https://example.com/video.mp4">
                                                </div>

                                                <div class="video-file-group"
                                                    style="{{ ($slide['video_source'] ?? '') == 'file' ? 'display:block;' : 'display:none;' }}">
                                                    <label class="form-label">Video File</label>
                                                    <div class="input-group mb-2">
                                                        <input type="text" name="content[slides][{{ $index }}][video_file]"
                                                            id="slide-video-{{ $index }}" class="form-control"
                                                            value="{{ $slide['video_file'] ?? '' }}"
                                                            placeholder="Select video or upload new" readonly>
                                                        <button type="button" class="btn btn-outline-secondary"
                                                            data-bs-toggle="modal" data-bs-target="#mediaLibraryModal"
                                                            data-input-target="#slide-video-{{ $index }}"
                                                            data-preview-target="#slide-video-preview-{{ $index }}">Select from
                                                            Library</button>
                                                    </div>
                                                    <input type="file" class="form-control video-file-input"
                                                        data-index="{{ $index }}" accept="video/mp4,video/webm">
                                                    <div class="mt-2 upload-status-{{ $index }}" style="display:none;">
                                                        <div class="progress" style="height: 5px;">
                                                            <div class="progress-bar" role="progressbar" style="width: 0%"></div>
                                                        </div>
                                                        <small class="text-muted status-text">Uploading...</small>
                                                    </div>
                                                    <div id="slide-video-preview-{{ $index }}">
                                                        @if(isset($slide['video_file']) && $slide['video_file'])
                                                            <div class="mt-2 p-2 border rounded bg-light">
                                                                <strong class="text-xs text-muted">Current Video</strong>
                                                                <video src="{{ asset($slide['video_file']) }}"
                                                                    style="height: 120px; width: 100%; object-fit: cover;" controls
                                                                    muted></video>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="mb-3 bg-field bg-color"
                                                style="{{ ($slide['bg_type'] ?? '') == 'color' ? '' : 'display:none;' }}">
                                                <label class="form-label">Background Color</label>
                                                <input type="color" name="content[slides][{{ $index }}][bg_color]"
                                                    class="form-control form-control-color"
                                                    value="{{ $slide['bg_color'] ?? '#333333' }}">
                                            </div>

                                            <hr>
                                            <h6 class="text-muted"><i data-feather="layers" class="me-1"></i> Overlay Settings</h6>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-check form-switch mt-4">
                                                        <input class="form-check-input" type="checkbox"
                                                            name="content[slides][{{ $index }}][overlay_enabled]" value="1" {{ ($slide['overlay_enabled'] ?? '1') ? 'checked' : '' }}>
                                                        <label class="form-check-label">Enable Dark Overlay</label>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label">Overlay Color</label>
                                                    <input type="color" name="content[slides][{{ $index }}][overlay_color]"
                                                        class="form-control form-control-color"
                                                        value="{{ $slide['overlay_color'] ?? '#000000' }}">
                                                </div>
                                                <div class="col-md-4">
                                                    <label class="form-label">Opacity (0 to 1)</label>
                                                    <input type="number" step="0.1" min="0" max="1"
                                                        name="content[slides][{{ $index }}][overlay_opacity]" class="form-control"
                                                        value="{{ $slide['overlay_opacity'] ?? '0.5' }}">
                                                </div>
                                            </div>
                                        </div>

                                        {{-- Style Tab --}}
                                        <div class="tab-pane fade" id="slide-style-{{ $index }}" role="tabpanel">
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label">Content Alignment</label>
                                                    <select name="content[slides][{{ $index }}][align]" class="form-select">
                                                        <option value="text-center" {{ ($slide['align'] ?? 'text-center') == 'text-center' ? 'selected' : '' }}>Center</option>
                                                        <option value="text-start" {{ ($slide['align'] ?? '') == 'text-start' ? 'selected' : '' }}>Left</option>
                                                        <option value="text-end" {{ ($slide['align'] ?? '') == 'text-end' ? 'selected' : '' }}>Right</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label">Button Style</label>
                                                    <select name="content[slides][{{ $index }}][btn_style]" class="form-select">
                                                        <option value="btn-primary" {{ ($slide['btn_style'] ?? 'btn-primary') == 'btn-primary' ? 'selected' : '' }}>Primary Solid
                                                        </option>
                                                        <option value="btn-secondary" {{ ($slide['btn_style'] ?? '') == 'btn-secondary' ? 'selected' : '' }}>Secondary Solid</option>
                                                        <option value="btn-dark" {{ ($slide['btn_style'] ?? '') == 'btn-dark' ? 'selected' : '' }}>Dark Solid</option>
                                                        <option value="btn-light" {{ ($slide['btn_style'] ?? '') == 'btn-light' ? 'selected' : '' }}>Light Solid</option>
                                                        <option value="btn-outline btn-outline-light" {{ ($slide['btn_style'] ?? '') == 'btn-outline btn-outline-light' ? 'selected' : '' }}>White Outline
                                                        </option>
                                                        <option value="btn-outline btn-outline-dark" {{ ($slide['btn_style'] ?? '') == 'btn-outline btn-outline-dark' ? 'selected' : '' }}>Dark Outline
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <button type="button" class="btn btn-outline-primary w-100" id="add-slide-btn"><i data-feather="plus"></i>
                        Add New
                        Slide</button>

                    {{-- Template for New Slide --}}
                    <template id="slide-template">
                        <div class="card mb-4 slide-item shadow-sm border" data-index="INDEX_PLACEHOLDER">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h5 class="mb-0 text-dark"><i data-feather="monitor" class="me-2"></i> New Slide</h5>
                                <button type="button" class="btn btn-danger btn-sm remove-slide" title="Remove Slide"><i
                                        data-feather="trash-2"></i></button>
                            </div>
                            <div class="card-body">
                                <ul class="nav nav-tabs nav-justified mb-3" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" data-bs-toggle="tab" href="#slide-content-INDEX_PLACEHOLDER"
                                            role="tab">Content</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-bs-toggle="tab" href="#slide-media-INDEX_PLACEHOLDER"
                                            role="tab">Background & Overlay</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" data-bs-toggle="tab" href="#slide-style-INDEX_PLACEHOLDER"
                                            role="tab">Style
                                            & Layout</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    {{-- Content Tab --}}
                                    <div class="tab-pane fade show active" id="slide-content-INDEX_PLACEHOLDER" role="tabpanel">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <div class="mb-3">
                                                    <label class="form-label">Title</label>
                                                    <div class="input-group">
                                                        <div class="input-group-text">
                                                            <input class="form-check-input mt-0" type="checkbox"
                                                                name="content[slides][INDEX_PLACEHOLDER][title_visible]"
                                                                value="1" checked title="Show/Hide">
                                                        </div>
                                                        <input type="text" name="content[slides][INDEX_PLACEHOLDER][title]"
                                                            class="form-control" placeholder="Enter slide title">
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Subtitle</label>
                                                    <div class="input-group">
                                                        <div class="input-group-text">
                                                            <input class="form-check-input mt-0" type="checkbox"
                                                                name="content[slides][INDEX_PLACEHOLDER][subtitle_visible]"
                                                                value="1" checked title="Show/Hide">
                                                        </div>
                                                        <input type="text" name="content[slides][INDEX_PLACEHOLDER][subtitle]"
                                                            class="form-control" placeholder="Enter slide subtitle">
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Description / Text</label>
                                                    <div class="input-group">
                                                        <div class="input-group-text">
                                                            <input class="form-check-input mt-0" type="checkbox"
                                                                name="content[slides][INDEX_PLACEHOLDER][text_visible]"
                                                                value="1" checked title="Show/Hide">
                                                        </div>
                                                        <textarea name="content[slides][INDEX_PLACEHOLDER][text]"
                                                            class="form-control" rows="2"
                                                            placeholder="Enter additional text (optional)"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-3">
                                                    <label class="form-label">Button Text</label>
                                                    <div class="input-group">
                                                        <div class="input-group-text">
                                                            <input class="form-check-input mt-0" type="checkbox"
                                                                name="content[slides][INDEX_PLACEHOLDER][button_visible]"
                                                                value="1" checked title="Show/Hide">
                                                        </div>
                                                        <input type="text"
                                                            name="content[slides][INDEX_PLACEHOLDER][button_text]"
                                                            class="form-control" placeholder="e.g. Learn More">
                                                    </div>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label">Button Link</label>
                                                    <input type="text" name="content[slides][INDEX_PLACEHOLDER][button_link]"
                                                        class="form-control" placeholder="e.g. /about">
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Media Tab --}}
                                    <div class="tab-pane fade" id="slide-media-INDEX_PLACEHOLDER" role="tabpanel">
                                        <div class="mb-3 video-input">
                                            <label class="form-label">Background Type</label>
                                            <select name="content[slides][INDEX_PLACEHOLDER][bg_type]"
                                                class="form-select bg-type-selector">
                                                <option value="image" selected>Image</option>
                                                <option value="video">Video (MP4/WebM)</option>
                                                <option value="color">Solid Color</option>
                                            </select>
                                        </div>

                                        <div class="mb-3 bg-field bg-image">
                                            <label class="form-label">Image</label>
                                            <div class="input-group mb-2">
                                                <input type="text" name="content[slides][INDEX_PLACEHOLDER][image]"
                                                    id="slide-image-INDEX_PLACEHOLDER" class="form-control"
                                                    placeholder="Select image or upload new" readonly>
                                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                                    data-bs-target="#mediaLibraryModal"
                                                    data-input-target="#slide-image-INDEX_PLACEHOLDER"
                                                    data-preview-target="#slide-image-preview-INDEX_PLACEHOLDER">Select from
                                                    Library</button>
                                            </div>
                                            <input type="file" name="content[slides][INDEX_PLACEHOLDER][image_file]"
                                                class="form-control">
                                            <div class="form-text">Upload a new file to replace the current one.</div>
                                            <div id="slide-image-preview-INDEX_PLACEHOLDER" class="mt-2"></div>
                                        </div>

                                        <div class="mb-3 bg-field bg-video" style="display:none;">
                                            <label class="form-label">Video Source</label>
                                            <select class="form-select mb-2 video-source-selector"
                                                name="content[slides][INDEX_PLACEHOLDER][video_source]"
                                                onchange="toggleVideoSource(this)">
                                                <option value="url" selected>External URL</option>
                                                <option value="file">Self-Hosted (Upload)</option>
                                            </select>

                                            <div class="video-url-group">
                                                <label class="form-label">Video URL (MP4/WebM)</label>
                                                <input type="text" class="form-control"
                                                    name="content[slides][INDEX_PLACEHOLDER][video_url]"
                                                    placeholder="https://example.com/video.mp4">
                                            </div>

                                            <div class="video-file-group" style="display: none;">
                                                <label class="form-label">Video File</label>
                                                <div class="input-group mb-2">
                                                    <input type="text" name="content[slides][INDEX_PLACEHOLDER][video_file]"
                                                        id="slide-video-INDEX_PLACEHOLDER" class="form-control"
                                                        placeholder="Select video or upload new" readonly>
                                                    <button type="button" class="btn btn-outline-secondary"
                                                        data-bs-toggle="modal" data-bs-target="#mediaLibraryModal"
                                                        data-input-target="#slide-video-INDEX_PLACEHOLDER"
                                                        data-preview-target="#slide-video-preview-INDEX_PLACEHOLDER">Select from
                                                        Library</button>
                                                </div>
                                                <input type="file" class="form-control"
                                                    name="content[slides][INDEX_PLACEHOLDER][video_file_upload]"
                                                    accept="video/mp4,video/webm" onchange="updateVideoFeedback(this)">
                                                <div id="slide-video-preview-INDEX_PLACEHOLDER"></div>
                                            </div>
                                        </div>

                                        <div class="mb-3 bg-field bg-color" style="display:none;">
                                            <label class="form-label">Background Color</label>
                                            <input type="color" name="content[slides][INDEX_PLACEHOLDER][bg_color]"
                                                class="form-control form-control-color" value="#333333">
                                        </div>

                                        <hr>
                                        <h6 class="text-muted"><i data-feather="layers" class="me-1"></i> Overlay Settings</h6>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-check form-switch mt-4">
                                                    <input class="form-check-input" type="checkbox"
                                                        name="content[slides][INDEX_PLACEHOLDER][overlay_enabled]" value="1"
                                                        checked>
                                                    <label class="form-check-label">Enable Dark Overlay</label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">Overlay Color</label>
                                                <input type="color" name="content[slides][INDEX_PLACEHOLDER][overlay_color]"
                                                    class="form-control form-control-color" value="#000000">
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label">Opacity (0 to 1)</label>
                                                <input type="number" step="0.1" min="0" max="1"
                                                    name="content[slides][INDEX_PLACEHOLDER][overlay_opacity]"
                                                    class="form-control" value="0.5">
                                            </div>
                                        </div>
                                    </div>

                                    {{-- Style Tab --}}
                                    <div class="tab-pane fade" id="slide-style-INDEX_PLACEHOLDER" role="tabpanel">
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Content Alignment</label>
                                                <select name="content[slides][INDEX_PLACEHOLDER][align]" class="form-select">
                                                    <option value="text-center" selected>Center</option>
                                                    <option value="text-start">Left</option>
                                                    <option value="text-end">Right</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Button Style</label>
                                                <select name="content[slides][INDEX_PLACEHOLDER][btn_style]"
                                                    class="form-select">
                                                    <option value="btn-primary" selected>Primary Solid</option>
                                                    <option value="btn-secondary">Secondary Solid</option>
                                                    <option value="btn-dark">Dark Solid</option>
                                                    <option value="btn-light">Light Solid</option>
                                                    <option value="btn-outline btn-outline-light">White Outline</option>
                                                    <option value="btn-outline btn-outline-dark">Dark Outline</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label class="form-label">Entry Animation</label>
                                                <div class="input-group">
                                                    <select name="content[slides][INDEX_PLACEHOLDER][animation_type]"
                                                        class="form-select">
                                                        <option value="" selected>None</option>
                                                        <optgroup label="Basic">
                                                            <option value="fadeIn">Fade In</option>
                                                            <option value="fadeInUp">Fade In Up</option>
                                                            <option value="fadeInDown">Fade In Down</option>
                                                            <option value="fadeInLeft">Fade In Left</option>
                                                            <option value="fadeInRight">Fade In Right</option>
                                                        </optgroup>
                                                        <optgroup label="Shorter">
                                                            <option value="fadeInUpShorter">Fade In Up Shorter</option>
                                                            <option value="fadeInDownShorter">Fade In Down Shorter</option>
                                                            <option value="fadeInLeftShorter">Fade In Left Shorter</option>
                                                            <option value="fadeInRightShorter">Fade In Right Shorter</option>
                                                        </optgroup>
                                                        <optgroup label="Attention Seekers">
                                                            <option value="bounce">Bounce</option>
                                                            <option value="flash">Flash</option>
                                                            <option value="pulse">Pulse</option>
                                                            <option value="rubberBand">RubberBand</option>
                                                            <option value="shake">Shake</option>
                                                            <option value="headShake">HeadShake</option>
                                                            <option value="swing">Swing</option>
                                                            <option value="tada">Tada</option>
                                                            <option value="wobble">Wobble</option>
                                                            <option value="jello">Jello</option>
                                                        </optgroup>
                                                        <optgroup label="Bouncing Entrances">
                                                            <option value="bounceIn">Bounce In</option>
                                                            <option value="bounceInDown">Bounce In Down</option>
                                                            <option value="bounceInLeft">Bounce In Left</option>
                                                            <option value="bounceInRight">Bounce In Right</option>
                                                            <option value="bounceInUp">Bounce In Up</option>
                                                        </optgroup>
                                                        <optgroup label="Fading Entrances">
                                                            <option value="fadeInDownBig">Fade In Down Big</option>
                                                            <option value="fadeInLeftBig">Fade In Left Big</option>
                                                            <option value="fadeInRightBig">Fade In Right Big</option>
                                                            <option value="fadeInUpBig">Fade In Up Big</option>
                                                        </optgroup>
                                                        <optgroup label="Flippers">
                                                            <option value="flip">Flip</option>
                                                            <option value="flipInX">Flip In X</option>
                                                            <option value="flipInY">Flip In Y</option>
                                                        </optgroup>
                                                        <optgroup label="Rotating Entrances">
                                                            <option value="rotateIn">Rotate In</option>
                                                            <option value="rotateInDownLeft">Rotate In Down Left</option>
                                                            <option value="rotateInDownRight">Rotate In Down Right</option>
                                                            <option value="rotateInUpLeft">Rotate In Up Left</option>
                                                            <option value="rotateInUpRight">Rotate In Up Right</option>
                                                        </optgroup>
                                                        <optgroup label="Sliding Entrances">
                                                            <option value="slideInUp">Slide In Up</option>
                                                            <option value="slideInDown">Slide In Down</option>
                                                            <option value="slideInLeft">Slide In Left</option>
                                                            <option value="slideInRight">Slide In Right</option>
                                                        </optgroup>
                                                        <optgroup label="Zoom Entrances">
                                                            <option value="zoomIn">Zoom In</option>
                                                            <option value="zoomInDown">Zoom In Down</option>
                                                            <option value="zoomInLeft">Zoom In Left</option>
                                                            <option value="zoomInRight">Zoom In Right</option>
                                                            <option value="zoomInUp">Zoom In Up</option>
                                                        </optgroup>
                                                        <optgroup label="Specials">
                                                            <option value="maskUp">Mask Up</option>
                                                            <option value="blurIn">Blur In</option>
                                                        </optgroup>
                                                    </select>
                                                    <input type="number"
                                                        name="content[slides][INDEX_PLACEHOLDER][animation_delay]"
                                                        class="form-control" placeholder="Delay ms" value="200"
                                                        style="max-width: 100px;">
                                                </div>
                                            </div>
                                        </div>

                                        <hr>
                                        <h6 class="text-muted"><i data-feather="type" class="me-1"></i> Title Styling</h6>
                                        <div class="row mb-3">
                                            <div class="col-md-4 mb-2">
                                                <label class="form-label small">Font Family</label>
                                                <select name="content[slides][INDEX_PLACEHOLDER][title_font_family]"
                                                    class="form-select form-select-sm">
                                                    <option value="">Default</option>
                                                    @foreach(['Arial', 'Helvetica', 'Times New Roman', 'Courier New', 'Verdana', 'Georgia', 'Poppins', 'Open Sans'] as $font)
                                                        <option value="{{ $font }}">{{ $font }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-4 mb-2">
                                                <label class="form-label small">Size (px)</label>
                                                <input type="number" name="content[slides][INDEX_PLACEHOLDER][title_font_size]"
                                                    class="form-control form-control-sm" placeholder="Default">
                                            </div>
                                            <div class="col-md-4 mb-2">
                                                <label class="form-label small">Color</label>
                                                <input type="color" name="content[slides][INDEX_PLACEHOLDER][title_color]"
                                                    class="form-control form-control-color" value="#ffffff">
                                            </div>
                                        </div>

                                        <div class="row mb-4">
                                            <label class="form-label small fw-bold">Title Shadow</label>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">Color</label>
                                                <input type="color"
                                                    name="content[slides][INDEX_PLACEHOLDER][title_shadow_color]"
                                                    class="form-control form-control-color" value="#000000">
                                            </div>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">X Offset</label>
                                                <input type="number" name="content[slides][INDEX_PLACEHOLDER][title_shadow_x]"
                                                    class="form-control form-control-sm" placeholder="0" value="0">
                                            </div>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">Y Offset</label>
                                                <input type="number" name="content[slides][INDEX_PLACEHOLDER][title_shadow_y]"
                                                    class="form-control form-control-sm" placeholder="0" value="0">
                                            </div>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">Blur</label>
                                                <input type="number"
                                                    name="content[slides][INDEX_PLACEHOLDER][title_shadow_blur]"
                                                    class="form-control form-control-sm" placeholder="0" value="0">
                                            </div>
                                        </div>

                                        <hr>
                                        <h6 class="text-muted"><i data-feather="type" class="me-1"></i> Subtitle Styling</h6>
                                        <div class="row mb-3">
                                            <div class="col-md-4 mb-2">
                                                <label class="form-label small">Font Family</label>
                                                <select name="content[slides][INDEX_PLACEHOLDER][subtitle_font_family]"
                                                    class="form-select form-select-sm">
                                                    <option value="">Default</option>
                                                    @foreach(['Arial', 'Helvetica', 'Times New Roman', 'Courier New', 'Verdana', 'Georgia', 'Poppins', 'Open Sans'] as $font)
                                                        <option value="{{ $font }}">{{ $font }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-4 mb-2">
                                                <label class="form-label small">Size (px)</label>
                                                <input type="number"
                                                    name="content[slides][INDEX_PLACEHOLDER][subtitle_font_size]"
                                                    class="form-control form-control-sm" placeholder="Default">
                                            </div>
                                            <div class="col-md-4 mb-2">
                                                <label class="form-label small">Color</label>
                                                <input type="color" name="content[slides][INDEX_PLACEHOLDER][subtitle_color]"
                                                    class="form-control form-control-color" value="#ffffff">
                                            </div>
                                        </div>

                                        <div class="row">
                                            <label class="form-label small fw-bold">Subtitle Shadow</label>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">Color</label>
                                                <input type="color"
                                                    name="content[slides][INDEX_PLACEHOLDER][subtitle_shadow_color]"
                                                    class="form-control form-control-color" value="#000000">
                                            </div>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">X Offset</label>
                                                <input type="number"
                                                    name="content[slides][INDEX_PLACEHOLDER][subtitle_shadow_x]"
                                                    class="form-control form-control-sm" placeholder="0" value="0">
                                            </div>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">Y Offset</label>
                                                <input type="number"
                                                    name="content[slides][INDEX_PLACEHOLDER][subtitle_shadow_y]"
                                                    class="form-control form-control-sm" placeholder="0" value="0">
                                            </div>
                                            <div class="col-md-3 mb-2">
                                                <label class="small text-muted">Blur</label>
                                                <input type="number"
                                                    name="content[slides][INDEX_PLACEHOLDER][subtitle_shadow_blur]"
                                                    class="form-control form-control-sm" placeholder="0" value="0">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>

                    @push('scripts')
                        <script>
                                     function toggleVideoSource(select) {
                                            const parent = select.closest('.video-input') || select.closest('.bg-video'); // Handle both contexts
                                            if (!parent) return;
                                            const urlGroup = parent.querySelector('.video-url-group');
                                            const fileGroup = parent.querySelector('.video-file-group');

                                            if (select.value === 'url') {
                                                if (urlGroup) urlGroup.style.display = 'block';
                                                if (fileGroup) fileGroup.style.display = 'none';
                                            } else {
                                                if (urlGroup) urlGroup.style.display = 'none';
                                                if (fileGroup) fileGroup.style.display = 'block';
                                            }
                                        }

                                        function updateVideoFeedback(input) {
                                            const file = input.files[0];
                                            if (file) {
                                                const parent = input.parentNode;
                                                let feedback = parent.querySelector('.video-upload-feedback');
                                                if (!feedback) {
                                                    feedback = document.createElement('div');
                                                    feedback.className = 'video-upload-feedback mt-2 text-success d-flex align-items-center';
                                                    parent.appendChild(feedback);
                                                }
                                                feedback.innerHTML = '<i data-feather="check-circle" class="me-2 text-success" width="16" height="16"></i> <span class="text-sm">Selected: <strong>' + file.name + '</strong></span>';
                                                feather.replace();
                                            }
                                        }

                                        document.addEventListener('DOMContentLoaded', function () {
                                            const container = document.getElementById('slides-container');
                                            const addBtn = document.getElementById('add-slide-btn');
                                            const template = document.getElementById('slide-template').innerHTML;

                                            // Dynamic Slide Addition
                                            addBtn.addEventListener('click', function () {
                                                const newIndex = new Date().getTime(); // Unique timestamp ID
                                                const newHtml = template.replace(/INDEX_PLACEHOLDER/g, newIndex);
                                                container.insertAdjacentHTML('beforeend', newHtml);
                                                feather.replace();
                                            });

                                            // Event Delegation for Slider Actions
                                            container.addEventListener('click', function (e) {
                                                // Remove Slide
                                                if (e.target.closest('.remove-slide')) {
                                                    if (confirm('Are you sure you want to delete this slide?')) {
                                                        e.target.closest('.slide-item').remove();
                                                    }
                                                }
                                            });

                                            // Event Delegation for Background Type Change
                                            container.addEventListener('change', function (e) {
                                                if (e.target.classList.contains('bg-type-selector')) {
                                                    const type = e.target.value;
                                                    const slideCard = e.target.closest('.slide-item');
                                                    // Hide all fields
                                                    slideCard.querySelectorAll('.bg-field').forEach(el => el.style.display = 'none');
                                                    // Show relevant field
                                                    if (type == 'image') slideCard.querySelector('.bg-image').style.display = 'block';
                                                    if (type == 'video') slideCard.querySelector('.bg-video').style.display = 'block';
                                                    if (type == 'color') slideCard.querySelector('.bg-color').style.display = 'block';
                                                }
                                            });
                                            // AJAX Video Upload Handler
                                            $(document).on('change', '.video-file-input', function () {
                                                let input = $(this);
                                                let index = input.data('index');
                                                let file = this.files[0];
                                                let statusDiv = $('.upload-status-' + index);
                                                let progressBar = statusDiv.find('.progress-bar');
                                                let statusText = statusDiv.find('.status-text');
                                                let hiddenInput = $('#slide-video-' + index);
                                                let previewDiv = $('#slide-video-preview-' + index);

                                                if (!file) return;

                                                if (file.size > 512 * 1024 * 1024) { // 500MB
                                                    alert('File is too large. Max 500MB.');
                                                    input.val('');
                                                    return;
                                                }

                                                let formData = new FormData();
                                                formData.append('video', file);
                                                formData.append('_token', '{{ csrf_token() }}');

                                                statusDiv.show();
                                                progressBar.width('0%');
                                                statusText.text('Uploading... ' + file.name);
                                                input.prop('disabled', true);

                                                $.ajax({
                                                    url: '{{ route('admin.media.upload-video') }}',
                                                    type: 'POST',
                                                    data: formData,
                                                    contentType: false,
                                                    processData: false,
                                                    xhr: function () {
                                                        var xhr = new window.XMLHttpRequest();
                                                        xhr.upload.addEventListener("progress", function (evt) {
                                                            if (evt.lengthComputable) {
                                                                var percentComplete = Math.round((evt.loaded / evt.total) * 100);
                                                                progressBar.width(percentComplete + '%');
                                                                statusText.text('Uploading... ' + percentComplete + '%');
                                                            }
                                                        }, false);
                                                        return xhr;
                                                    },
                                                    success: function (response) {
                                                        if (response.success) {
                                                            statusText.text('Upload Complete!').addClass('text-success');
                                                            hiddenInput.val(response.url);

                                                            // Create/Update Preview
                                                            let videoHtml = `
                                                                                                                                                                                                    <div class="mt-2 p-2 border rounded bg-light">
                                                                                                                                                                                                        <strong class="text-xs text-muted">Current Video</strong>
                                                                                                                                                                                                        <video src="${response.url}" style="height: 120px; width: 100%; object-fit: cover;" controls muted></video>
                                                                                                                                                                                                                                                                                                                                               </div>
                                                                                                                                                                                                                        `;
                                                            previewDiv.html(videoHtml);
                                                        } else {
                                                            alert('Upload failed: ' + response.message);
                                                            statusText.text('Failed').addClass('text-danger');
                                                        }
                                                    },
                                                    error: function (xhr) {
                                                        console.error(xhr);
                                                        alert('Server Error during upload.');
                                                        statusText.text('Error').addClass('text-danger');
                                                    },
                                                    complete: function () {
                                                        input.prop('disabled', false);
                                                        setTimeout(() => { if (progressBar.width() == '100%') statusDiv.fadeOut(); }, 3000);
                                                    }
                                                });
                                            });
                                        });
                                    </script>
                    @endpush

                @elseif($section->section_identifier === 'home_services_with_image')
                        <div class="alert alert-info">
                            <i data-feather="info" class="me-2"></i> Manage the "What We Do" section (Image Left, Accordion Right).
                            The services themselves are managed via the <a href="{{ route('admin.services.index') }}">Services</a>
                            module.
                        </div>

                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label class="form-label">Title</label>
                                    <input type="text" name="content[title]" class="form-control"
                                        value="{{ $section->content['title'] ?? '' }}">
                                </div><!--/col-md-8-->

                                <div class="mb-3">
                                    <label class="form-label">Subtitle (Red Text)</label>
                                    <input type="text" name="content[subtitle]" class="form-control"
                                        value="{{ $section->content['subtitle'] ?? '' }}">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Description</label>
                                    <textarea name="content[description]" class="form-control"
                                        rows="4">{{ $section->content['description'] ?? '' }}</textarea>
                                </div>
                            </div><!--/col-md-8-->

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Main Image (Left Side)</label>
                                    <div class="input-group mb-2">
                                        <input type="text" name="content[image]" id="service_image" class="form-control"
                                            value="{{ $section->content['image'] ?? '' }}" readonly>
                                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                            data-bs-target="#mediaLibraryModal" data-input-target="#service_image"
                                            data-preview-target="#service_image_preview">Select</button>
                                    </div>
                                    <input type="file" name="content[image_file]" class="form-control">
                                    <div id="service_image_preview" class="mt-2 text-center">
                                        @if(!empty($section->content['image']))
                                            <img src="{{ asset($section->content['image']) }}" class="img-fluid rounded shadow-sm"
                                                style="max-height: 150px;">
                                        @endif
                                    </div>
                                </div>

                                <hr>
                                <label class="form-label fw-bold">Button</label>
                                <div class="mb-3">
                                    <label class="form-label">Button Text</label>
                                    <input type="text" name="content[button_text]" class="form-control"
                                        value="{{ $section->content['button_text'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Button Link</label>
                                    <input type="text" name="content[button_link]" class="form-control"
                                        value="{{ $section->content['button_link'] ?? '' }}">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Button Style</label>
                                    <select name="content[btn_style]" class="form-select">
                                        <option value="btn-primary" {{ ($section->content['btn_style'] ?? '') == 'btn-primary' ? 'selected' : '' }}>Primary (Red)</option>
                                        <option value="btn-secondary" {{ ($section->content['btn_style'] ?? '') == 'btn-secondary' ? 'selected' : '' }}>Secondary (Dark)</option>
                                        <option value="btn-dark" {{ ($section->content['btn_style'] ?? '') == 'btn-dark' ? 'selected' : '' }}>Dark</option>
                                        <option value="btn-light" {{ ($section->content['btn_style'] ?? '') == 'btn-light' ? 'selected' : '' }}>Light</option>
                                        <option value="btn-outline btn-outline-primary" {{ ($section->content['btn_style'] ?? '') == 'btn-outline btn-outline-primary' ? 'selected' : '' }}>Outline Primary</option>
                                        <option value="btn-outline btn-outline-dark" {{ ($section->content['btn_style'] ?? '') == 'btn-outline btn-outline-dark' ? 'selected' : '' }}>Outline Dark</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Entry Animation</label>
                                    <div class="input-group">
                                        <select name="content[animation_type]" class="form-select">
                                            <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </select>
                                        <input type="number" name="content[animation_delay]" class="form-control"
                                            placeholder="Delay ms" value="{{ $section->content['animation_delay'] ?? '200' }}"
                                            style="max-width: 100px;">
                                    </div>
                                </div>
                            </div><!--/col-md-4-->
                        </div><!--/row-->

                        <hr>
                        <h5 class="mb-3">Section Styling</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Background Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[bg_color]"
                                        value="{{ $section->content['bg_color'] ?? '#ffffff' }}" title="Choose color">
                                    <input type="text" class="form-control" value="{{ $section->content['bg_color'] ?? '#ffffff' }}"
                                        readonly>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title/Text Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[text_color]"
                                        value="{{ $section->content['text_color'] ?? '#333333' }}" title="Choose color">
                                    <input type="text" class="form-control"
                                        value="{{ $section->content['text_color'] ?? '#333333' }}" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'home_portfolio_tabs')
                        {{-- Home Portfolio Tabs --}}
                        <div class="alert alert-info">
                            Manage the "Empowering Excellence" tabs section.
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Main Title</label>
                            <input type="text" name="content[title]" class="form-control"
                                value="{{ $section->content['title'] ?? '' }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Subtitle</label>
                            <input type="text" name="content[subtitle]" class="form-control"
                                value="{{ $section->content['subtitle'] ?? '' }}">
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                        <hr>
                        <h5>Tabs</h5>
                        <div class="row">
                            @php
                                $tabs = $section->content['tabs'] ?? [];
                                // Ensure at least 2 tabs structure exists or default to empty
                                $tabs = array_pad($tabs, 2, ['title' => '', 'content' => '', 'image' => '']);
                            @endphp

                            @foreach($tabs as $index => $tab)
                                <div class="col-md-6">
                                    <div class="card mb-3">
                                        <div class="card-header fw-bold">Tab {{ $index + 1 }}</div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label class="form-label">Tab Title</label>
                                                <input type="text" name="content[tabs][{{ $index }}][title]" class="form-control"
                                                    value="{{ $tab['title'] ?? '' }}">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Content</label>
                                                <textarea name="content[tabs][{{ $index }}][content]"
                                                    class="form-control rich-text-editor"
                                                    rows="4">{{ $tab['content'] ?? '' }}</textarea>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Image</label>
                                                <div class="input-group mb-2">
                                                    <input type="text" name="content[tabs][{{ $index }}][image]"
                                                        id="tab-image-{{ $index }}" class="form-control"
                                                        value="{{ $tab['image'] ?? '' }}" readonly>
                                                    <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                                        data-bs-target="#mediaLibraryModal" data-input-target="#tab-image-{{ $index }}"
                                                        data-preview-target="#tab-image-preview-{{ $index }}">Select</button>
                                                </div>
                                                <input type="file" name="content[tabs][{{ $index }}][image_file]" class="form-control">
                                                <div id="tab-image-preview-{{ $index }}" class="mt-2">
                                                    @if(!empty($tab['image']))
                                                        <img src="{{ asset($tab['image']) }}" alt="Tab Image" class="img-fluid rounded"
                                                            style="max-height: 100px;">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    @elseif($section->section_identifier === 'home_logos_grid')
                        {{-- Home Logos Grid --}}
                        <div class="alert alert-info">
                            Manage the Partner/Client logos.
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Section Title</label>
                            <input type="text" name="content[title]" class="form-control"
                                value="{{ $section->content['title'] ?? "We're proud to work with" }}">
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Upload New Logos (Multiple)</label>
                            <input type="file" name="content[new_logos][]" class="form-control" multiple accept="image/*">
                            <div class="form-text">Select multiple files to upload.</div>
                        </div>

                        <div class="row mt-4">
                            @foreach($section->content['logos'] ?? [] as $logoPath)
                                <div class="col-6 col-md-3 col-lg-2 mb-3 text-center">
                                    <div class="card h-100 shadow-sm">
                                        <div class="card-body p-2 d-flex align-items-center justify-content-center"
                                            style="height: 100px;">
                                            <img src="{{ asset($logoPath) }}" class="img-fluid" style="max-height: 80px;" alt="Logo">
                                        </div>
                                        <div class="card-footer p-1">
                                            <input type="hidden" name="content[logos][]" value="{{ $logoPath }}">
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="checkbox" name="content[remove_logos][]"
                                                    value="{{ $logoPath }}" id="remove_{{ $loop->index }}">
                                                <label class="form-check-label text-danger small"
                                                    for="remove_{{ $loop->index }}">Remove</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <hr>
                        <h5 class="mb-3">Section Styling</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Background Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[bg_color]"
                                        value="{{ $section->content['bg_color'] ?? '#ffffff' }}" title="Choose color">
                                    <input type="text" class="form-control" value="{{ $section->content['bg_color'] ?? '#ffffff' }}"
                                        readonly>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title/Text Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[text_color]"
                                        value="{{ $section->content['text_color'] ?? '#333333' }}" title="Choose color">
                                    <input type="text" class="form-control"
                                        value="{{ $section->content['text_color'] ?? '#333333' }}" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'home_news')
                        {{-- Home News --}}
                        <div class="alert alert-info">
                            Manage the News & Articles section.
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Subtitle (Red Text)</label>
                            <input type="text" name="content[subtitle]" class="form-control"
                                value="{{ $section->content['subtitle'] ?? 'Our Blog' }}">
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Main Title</label>
                            <input type="text" name="content[title]" class="form-control"
                                value="{{ $section->content['title'] ?? 'News and Articles' }}">
                        </div>

                        <hr>
                        <h5 class="mb-3">Section Styling</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Background Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[bg_color]"
                                        value="{{ $section->content['bg_color'] ?? '#ffffff' }}" title="Choose color">
                                    <input type="text" class="form-control" value="{{ $section->content['bg_color'] ?? '#ffffff' }}"
                                        readonly>
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Title/Text Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[text_color]"
                                        value="{{ $section->content['text_color'] ?? '#333333' }}" title="Choose color">
                                    <input type="text" class="form-control"
                                        value="{{ $section->content['text_color'] ?? '#333333' }}" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'home_banner_simple')
                        <div class="alert alert-info">Simple Banner with Background and Text</div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Background Image</label>
                                <div class="input-group">
                                    <input type="text" name="content[image]" id="banner-bg" class="form-control"
                                        value="{{ $section->content['image'] ?? '' }}" readonly>
                                    <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                        data-bs-target="#mediaLibraryModal" data-input-target="#banner-bg"
                                        data-preview-target="#banner-bg-preview">Select</button>
                                </div>
                                <div id="banner-bg-preview" class="mt-2">@if(!empty($section->content['image'])) <img
                                src="{{ asset($section->content['image']) }}" style="height: 100px;"> @endif</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Overlay Opacity (0.0 - 1.0)</label>
                                <input type="number" step="0.1" min="0" max="1" name="content[overlay_opacity]" class="form-control"
                                    value="{{ $section->content['overlay_opacity'] ?? '0.5' }}">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Padding Vertical (py-*)</label>
                                <select name="content[padding_y]" class="form-select">
                                    @foreach(range(0, 5) as $i)
                                        <option value="{{ $i }}" {{ ($section->content['padding_y'] ?? '5') == $i ? 'selected' : '' }}>
                                            Level {{ $i }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Min Height (px)</label>
                                <input type="number" name="content[min_height]" class="form-control"
                                    value="{{ $section->content['min_height'] ?? '400' }}" placeholder="e.g. 400">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Text Align</label>
                                <select name="content[text_align]" class="form-select">
                                    <option value="text-start" {{ ($section->content['text_align'] ?? '') == 'text-start' ? 'selected' : '' }}>Left</option>
                                    <option value="text-center" {{ ($section->content['text_align'] ?? 'text-center') == 'text-center' ? 'selected' : '' }}>Center</option>
                                    <option value="text-end" {{ ($section->content['text_align'] ?? '') == 'text-end' ? 'selected' : '' }}>Right</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>
                                            None</option>
                                        <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                        <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                        <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Title</label>
                            <input type="text" name="content[title]" class="form-control"
                                value="{{ $section->content['title'] ?? 'Banner Title' }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Subtitle</label>
                            <input type="text" name="content[subtitle]" class="form-control"
                                value="{{ $section->content['subtitle'] ?? 'Banner Subtitle' }}">
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Button Text</label>
                                <input type="text" name="content[btn_text]" class="form-control"
                                    value="{{ $section->content['btn_text'] ?? '' }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Button Link</label>
                                <input type="text" name="content[btn_link]" class="form-control"
                                    value="{{ $section->content['btn_link'] ?? '' }}">
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'home_video_block')
                        <div class="alert alert-info">Video Block (Centered)</div>
                        <div class="mb-3">
                            <label class="form-label">Video Source Type</label>
                            <select name="content[source_type]" class="form-select">
                                <option value="youtube" {{ ($section->content['source_type'] ?? '') == 'youtube' ? 'selected' : '' }}>
                                    YouTube / Vimeo URL</option>
                                <option value="file" {{ ($section->content['source_type'] ?? '') == 'file' ? 'selected' : '' }}>Self
                                    Hosted File</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Video URL / File Path</label>
                            <div class="input-group">
                                <input type="text" name="content[video_url]" id="video-url" class="form-control"
                                    value="{{ $section->content['video_url'] ?? '' }}">
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#video-url">Select File</button>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Cover Image</label>
                            <div class="input-group">
                                <input type="text" name="content[cover_image]" id="video-cover" class="form-control"
                                    value="{{ $section->content['cover_image'] ?? '' }}" readonly>
                                <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal"
                                    data-bs-target="#mediaLibraryModal" data-input-target="#video-cover"
                                    data-preview-target="#video-cover-preview">Select</button>
                            </div>
                            <div id="video-cover-preview" class="mt-2">@if(!empty($section->content['cover_image'])) <img
                            src="{{ asset($section->content['cover_image']) }}" style="height: 100px;"> @endif</div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Container Width</label>
                                <select name="content[container_width]" class="form-select">
                                    <option value="container" {{ ($section->content['container_width'] ?? 'container') == 'container' ? 'selected' : '' }}>Fixed (Container)</option>
                                    <option value="container-fluid" {{ ($section->content['container_width'] ?? '') == 'container-fluid' ? 'selected' : '' }}>Full Width (Fluid)</option>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Padding Vertical</label>
                                <select name="content[padding_y]" class="form-select">
                                    @foreach(range(0, 5) as $i)
                                        <option value="{{ $i }}" {{ ($section->content['padding_y'] ?? '5') == $i ? 'selected' : '' }}>
                                            Level {{ $i }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Styling</label>
                                <div class="form-check">
                                    <input type="checkbox" name="content[box_shadow]" value="1" class="form-check-input"
                                        id="vid_shadow" {{ !empty($section->content['box_shadow']) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="vid_shadow">Box Shadow</label>
                                </div>
                                <div class="input-group mt-2">
                                    <span class="input-group-text">Radius</span>
                                    <input type="number" name="content[border_radius]" class="form-control"
                                        value="{{ $section->content['border_radius'] ?? '0' }}" placeholder="px">
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>
                                            None</option>
                                        <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                        <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                        <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'home_multi_column')
                        <div class="alert alert-info">Multi-Column Layout Container</div>
                        <div class="mb-3">
                            <label class="form-label">Column Layout</label>
                            <select name="content[layout]" class="form-select">
                                <option value="2" {{ ($section->content['layout'] ?? '') == '2' ? 'selected' : '' }}>2 Columns (50/50)
                                </option>
                                <option value="3" {{ ($section->content['layout'] ?? '') == '3' ? 'selected' : '' }}>3 Columns
                                    (33/33/33)</option>
                                <option value="4" {{ ($section->content['layout'] ?? '') == '4' ? 'selected' : '' }}>4 Columns
                                    (25/25/25/25)</option>
                            </select>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Gap (Gutter)</label>
                                <select name="content[gap]" class="form-select">
                                    @foreach(range(0, 5) as $i)
                                        <option value="{{ $i }}" {{ ($section->content['gap'] ?? '4') == $i ? 'selected' : '' }}>Level
                                            {{ $i }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Vertical Align</label>
                                <select name="content[align_items]" class="form-select">
                                    <option value="align-items-start" {{ ($section->content['align_items'] ?? '') == 'align-items-start' ? 'selected' : '' }}>Top</option>
                                    <option value="align-items-center" {{ ($section->content['align_items'] ?? '') == 'align-items-center' ? 'selected' : '' }}>Center</option>
                                    <option value="align-items-end" {{ ($section->content['align_items'] ?? '') == 'align-items-end' ? 'selected' : '' }}>Bottom</option>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Background Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[bg_color]"
                                        value="{{ $section->content['bg_color'] ?? '#ffffff' }}" title="Choose color">
                                    <input type="text" class="form-control" value="{{ $section->content['bg_color'] ?? '#ffffff' }}"
                                        readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>
                        <hr>
                        @php $cols = 4; @endphp
                        <ul class="nav nav-tabs" id="colTabs" role="tablist">
                            @for($i = 1; $i <= $cols; $i++)
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link {{ $i == 1 ? 'active' : '' }}" id="col{{$i}}-tab" data-bs-toggle="tab"
                                        data-bs-target="#col{{$i}}" type="button" role="tab">Column {{$i}}</button>
                                </li>
                            @endfor
                        </ul>
                        <div class="tab-content pt-3" id="colTabsContent">
                            @for($i = 1; $i <= $cols; $i++)
                                <div class="tab-pane fade {{ $i == 1 ? 'show active' : '' }}" id="col{{$i}}" role="tabpanel">
                                    <div class="mb-3">
                                        <label class="form-label">Column {{$i}} Content</label>
                                        <textarea name="content[columns][{{$i}}][html]" class="form-control rich-text-editor"
                                            rows="5">{{ $section->content['columns'][$i]['html'] ?? '' }}</textarea>
                                    </div>
                                </div>
                            @endfor
                        </div>

                    @elseif($section->section_identifier === 'home_newsletter')
                        {{-- Home Newsletter --}}
                        <div class="alert alert-info">
                            Manage the Newsletter Signup section text.
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Heading</label>
                            <input type="text" name="content[title]" class="form-control"
                                value="{{ $section->content['title'] ?? '' }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea name="content[description]" class="form-control"
                                rows="2">{{ $section->content['description'] ?? '' }}</textarea>
                        </div>

                        <hr>
                        <h5 class="mb-3">Section Styling</h5>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Background Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[bg_color]"
                                        value="{{ $section->content['bg_color'] ?? '#F4F4F4' }}" title="Choose color">
                                    <input type="text" class="form-control" value="{{ $section->content['bg_color'] ?? '#F4F4F4' }}"
                                        readonly>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Title Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[title_color]"
                                        value="{{ $section->content['title_color'] ?? '#333333' }}" title="Choose color">
                                    <input type="text" class="form-control"
                                        value="{{ $section->content['title_color'] ?? '#333333' }}" readonly>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Text Color</label>
                                <div class="input-group">
                                    <input type="color" class="form-control form-control-color" name="content[text_color]"
                                        value="{{ $section->content['text_color'] ?? '#777777' }}" title="Choose color">
                                    <input type="text" class="form-control"
                                        value="{{ $section->content['text_color'] ?? '#777777' }}" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Entry Animation</label>
                                <div class="input-group">
                                    <select name="content[animation_type]" class="form-select">
                                        <option value="" {{ ($section->content['animation_type'] ?? '') == '' ? 'selected' : '' }}>None</option>
                                        <optgroup label="Basic">
                                            <option value="fadeIn" {{ ($section->content['animation_type'] ?? '') == 'fadeIn' ? 'selected' : '' }}>Fade In</option>
                                            <option value="fadeInUp" {{ ($section->content['animation_type'] ?? '') == 'fadeInUp' ? 'selected' : '' }}>Fade In Up</option>
                                            <option value="fadeInDown" {{ ($section->content['animation_type'] ?? '') == 'fadeInDown' ? 'selected' : '' }}>Fade In Down</option>
                                            <option value="fadeInLeft" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeft' ? 'selected' : '' }}>Fade In Left</option>
                                            <option value="fadeInRight" {{ ($section->content['animation_type'] ?? '') == 'fadeInRight' ? 'selected' : '' }}>Fade In Right</option>
                                        </optgroup>
                                        <optgroup label="Shorter">
                                            <option value="fadeInUpShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInUpShorter' ? 'selected' : '' }}>Fade In Up Shorter</option>
                                            <option value="fadeInLeftShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInLeftShorter' ? 'selected' : '' }}>Fade In Left Shorter</option>
                                            <option value="fadeInRightShorter" {{ ($section->content['animation_type'] ?? '') == 'fadeInRightShorter' ? 'selected' : '' }}>Fade In Right Shorter</option>
                                        </optgroup>
                                        <optgroup label="Attention Seekers">
                                            <option value="bounce" {{ ($section->content['animation_type'] ?? '') == 'bounce' ? 'selected' : '' }}>Bounce</option>
                                            <option value="pulse" {{ ($section->content['animation_type'] ?? '') == 'pulse' ? 'selected' : '' }}>Pulse</option>
                                            <option value="tada" {{ ($section->content['animation_type'] ?? '') == 'tada' ? 'selected' : '' }}>Tada</option>
                                            <option value="wobble" {{ ($section->content['animation_type'] ?? '') == 'wobble' ? 'selected' : '' }}>Wobble</option>
                                        </optgroup>
                                        <optgroup label="Bouncing">
                                            <option value="bounceIn" {{ ($section->content['animation_type'] ?? '') == 'bounceIn' ? 'selected' : '' }}>Bounce In</option>
                                        </optgroup>
                                        <optgroup label="Zoom">
                                            <option value="zoomIn" {{ ($section->content['animation_type'] ?? '') == 'zoomIn' ? 'selected' : '' }}>Zoom In</option>
                                        </optgroup>
                                        <optgroup label="Sliding">
                                            <option value="slideInUp" {{ ($section->content['animation_type'] ?? '') == 'slideInUp' ? 'selected' : '' }}>Slide In Up</option>
                                        </optgroup>
                                        <optgroup label="Specials">
                                            <option value="maskUp" {{ ($section->content['animation_type'] ?? '') == 'maskUp' ? 'selected' : '' }}>Mask Up</option>
                                            <option value="blurIn" {{ ($section->content['animation_type'] ?? '') == 'blurIn' ? 'selected' : '' }}>Blur In</option>
                                        </optgroup>
                                    </select>
                                    <input type="number" name="content[animation_delay]" class="form-control" placeholder="Delay ms"
                                        value="{{ $section->content['animation_delay'] ?? '200' }}" style="max-width: 100px;">
                                </div>
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'about_intro')
                                {{-- About Page Intro Section --}}
                                <div class="mb-3">
                                    <label class="form-label">Heading</label>
                                    <input type="text" name="content[heading]" class="form-control"
                                        value="{{ $section->content['heading'] ?? '' }}" placeholder="About Us">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Sub-Heading / Tagline</label>
                                    <textarea name="content[subheading]" class="form-control"
                                        rows="2">{{ $section->content['subheading'] ?? '' }}</textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Main Content</label>
                                    <textarea name="content[body]" class="form-control rich-text-editor"
                                        rows="10">{{ $section->content['body'] ?? '' }}</textarea>
                                    <div class="form-text">HTML is allowed.</div>
                                </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Side Image</label>
                            <input type="file" name="content[image]" class="form-control">
                            @if(isset($section->content['image']) && $section->content['image'])
                                <div class="mt-2">
                                    <img src="{{ asset($section->content['image']) }}" alt="Preview" style="height: 150px; width: auto;"
                                        class="rounded border">
                                </div>
                            @endif
                        </div>

                    @elseif($section->section_identifier === 'contact_info')
                        {{-- Contact Info Section --}}
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><i data-feather="phone" class="width-15 height-15 me-1 text-muted"></i> Phone
                                    Number</label>
                                <input type="text" name="content[phone]" class="form-control" value="{{ $section->content['phone'] ?? '' }}"
                                    placeholder="(800) 123-4567">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Phone Hours</label>
                                <input type="text" name="content[phone_hours]" class="form-control"
                                    value="{{ $section->content['phone_hours'] ?? '' }}">
                            </div>
                        </div>



                        <div class="mb-3">
                            <label class="form-label"><i data-feather="map-pin" class="width-15 height-15 me-1 text-muted"></i>
                                Address</label>
                            <input type="text" name="content[address]" class="form-control"
                                value="{{ $section->content['address'] ?? '' }}">
                        </div>

                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><i data-feather="mail" class="width-15 height-15 me-1 text-muted"></i> Email
                                    Address</label>
                                <input type="email" name="content[email]" class="form-control"
                                    value="{{ $section->content['email'] ?? '' }}">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><i data-feather="linkedin" class="width-15 height-15 me-1 text-muted"></i>
                                    LinkedIn
                                    URL</label>
                                <input type="url" name="content[linkedin_url]" class="form-control"
                                    value="{{ $section->content['linkedin_url'] ?? '' }}">
                            </div>
                        </div>

                    @elseif($section->section_identifier === 'careers_intro')
                {{-- Careers Intro Section --}}
                <div class="mb-3">
                    <label class="form-label"><i data-feather="type" class="width-15 height-15 me-1 text-muted"></i> Title</label>
                    <input type="text" name="content[title]" class="form-control" value="{{ $section->content['title'] ?? '' }}">
                </div>
                <div class="mb-3">
                    <label class="form-label">Intro Text</label>
                    <textarea name="content[text]" class="form-control" rows="4">{{ $section->content['text'] ?? '' }}</textarea>
                </div>

            @else
                {{-- Default / Fallback Generic Fields --}}
                <div class="alert alert-warning">
                    No specific form layout found for "<strong>{{ $section->section_identifier }}</strong>". Showing generic
                    fields.
                </div>

                <div class="mb-3">
                    <label class="form-label"><i data-feather="type" class="width-15 height-15 me-1 text-muted"></i> Heading /
                        Title</label>
                    <input type="text" name="content[title]" class="form-control" value="{{ $section->content['title'] ?? '' }}">
                </div>

                <div class="mb-3">
                    <label class="form-label">Content / Body</label>
                    <textarea name="content[body]" class="form-control rich-text-editor"
                        rows="6">{{ $section->content['body'] ?? '' }}</textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label">Image</label>
                    <input type="file" name="content[image]" class="form-control">
                    @if(isset($section->content['image']) && $section->content['image'])
                        <div class="mt-2">
                            <img src="{{ asset($section->content['image']) }}" alt="Preview" style="height: 150px; width: auto;"
                                class="rounded border">
                        </div>
                    @endif
                </div>
            @endif

            <div class="mt-4">
                <button type="submit" class="btn btn-success">Save Changes</button>
                <a href="{{ route('admin.pages.sections.index', $page->id) }}" class="btn btn-secondary">Cancel</a>
            </div>
            </form>
        </div>
        </div>
        </div>
        @include('admin.media.modal')
@endsection