@extends('layouts.admin')

@section('title', 'Add Section')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Add Section to {{ $page->title }}</h1>
        <a href="{{ route('admin.pages.sections.index', $page->id) }}" class="btn btn-secondary">Back</a>
    </div>

    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.pages.sections.store', $page->id) }}" method="POST">
                @csrf
                <div class="mb-3">
                    <label class="form-label">Section Type (Identifier)</label>
                    <select name="section_identifier" class="form-select" required>
                        <option value="">Select Section Type...</option>
                        <optgroup label="Home Page">
                            <option value="home_slider">Home Slider (Hero)</option>
                            <option value="home_features_overlap">Home Features (3 Overlapping Boxes)</option>
                            <option value="home_services_with_image">Home Services (Accordion + Image)</option>
                            <option value="home_portfolio_tabs">Home Portfolio (Tabs)</option>
                            <option value="home_logos_grid">Home Logos/Partners Grid</option>
                            <option value="home_news">Home News & Articles</option>
                            <option value="home_newsletter">Home Newsletter Signup</option>
                            <option value="home_banner_simple">Simple Banner (Image/Video + Text)</option>
                            <option value="home_video_block">Video Block (Centered Video)</option>
                            <option value="home_multi_column">Multi-Column Container (2-4 Cols)</option>
                        </optgroup>
                        <optgroup label="About Page">
                            <option value="about_intro">Introduction Text</option>
                            <option value="about_features">Features List & Chart</option>
                            <option value="about_services_grid">Reliable Services Grid</option>
                            <option value="about_bottom">Bottom Content</option>
                        </optgroup>
                        <optgroup label="General">
                            <option value="generic_text">Generic Text Block</option>
                        </optgroup>
                    </select>
                    <div class="form-text">Choose the type of section from the template structure.</div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Order Priority</label>
                    <input type="number" name="order" class="form-control" value="0">
                </div>
                <button type="submit" class="btn btn-primary">Create & Edit Content</button>
            </form>
        </div>
    </div>
@endsection