@extends('layouts.admin')

@section('title', 'Pages')

@section('content')
    <h1 class="h3 mb-3">Pages</h1>

    <div class="card">
        <div class="table-responsive">
            <table class="table table-hover my-0">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Slug</th>
                        <th>Template</th>
                        <th>Last Updated</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($pages as $page)
                        <tr>
                            <td>{{ $page->title }}</td>
                            <td><span class="badge bg-secondary">{{ $page->slug }}</span></td>
                            <td>{{ ucfirst($page->template) }}</td>
                            <td>{{ \Carbon\Carbon::parse($page->updated_at)->diffForHumans() }}</td>
                            <td class="text-end">
                                <a href="{{ route('admin.pages.sections.index', $page->id) }}"
                                    class="btn btn-sm btn-info me-1">Sections</a>
                                <a href="{{ route('admin.pages.edit', $page->id) }}" class="btn btn-sm btn-primary">Edit</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection