@extends('layouts.admin')

@section('title', 'Edit Page: ' . $page->title)

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Edit Page: {{ $page->title }}</h1>
        <a href="{{ route('admin.pages.index') }}" class="btn btn-secondary">Back to List</a>
    </div>

    <form action="{{ route('admin.pages.update', $page->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-md-8">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Main Content</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Page Title</label>
                            <input type="text" class="form-control" name="title" value="{{ $page->title }}" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">URL Slug</label>
                            <input type="text" class="form-control" name="slug" value="{{ $page->slug }}"
                                placeholder="Auto-generated from title if empty">
                            <div class="form-text">Controls the URL (e.g., /your-slug). Leave empty to auto-generate from
                                title. Supports English, Arabic, and symbols.</div>
                        </div>
                    </div>
                </div>

                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">Hero Section</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Hero Title</label>
                            <input type="text" class="form-control" name="hero_title" value="{{ $page->hero_title }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Hero Subtitle</label>
                            <textarea class="form-control" name="hero_subtitle"
                                rows="2">{{ $page->hero_subtitle }}</textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Hero Image</label>
                            <input type="file" class="form-control" name="hero_image">
                            @if($page->hero_image)
                                <div class="mt-2">
                                    <img src="{{ $page->hero_image }}" class="img-fluid rounded" style="max-height: 200px;">
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card mb-3">
                    <div class="card-header">
                        <h5 class="card-title mb-0">SEO Settings</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Meta Title</label>
                            <input type="text" class="form-control" name="seo_title" value="{{ $page->seo_title }}">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Meta Description</label>
                            <textarea class="form-control" name="seo_description"
                                rows="3">{{ $page->seo_description }}</textarea>
                        </div>
                    </div>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-primary btn-lg">Update Page</button>
                </div>
            </div>
        </div>
    </form>
@endsection