@extends('layouts.admin')

@section('title', 'Newsletter Subscribers')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="h3">Newsletter Subscribers</h1>
        <a href="{{ route('admin.newsletter.export') }}" class="btn btn-secondary">Export CSV</a>
    </div>

    <div class="card">
        <table class="table table-hover my-0">
            <thead>
                <tr>
                    <th>Email</th>
                    <th>Subscribed Date</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                @foreach($subscribers as $sub)
                    <tr>
                        <td>{{ $sub->email }}</td>
                        <td>{{ \Carbon\Carbon::parse($sub->created_at)->format('M d, Y H:i') }}</td>
                        <td><span class="badge bg-success">Active</span></td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection